/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.extractors;

import com.adaptavist.confluence.forums.service.extractors.AbstractForumExtractor;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.google.common.collect.ImmutableList;
import java.util.Collection;

public class LastActivityDateForumExtractor
extends AbstractForumExtractor {
    public static final String ANONYMOUS = "anonymous";

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (searchable instanceof Page) {
            Page page = (Page)searchable;
            ContentEntityObject lastActivity = this.getPageLastActivity(page);
            long lastActivityTime = lastActivity.getLastModificationDate().getTime();
            String lastActivityAuthorUsername = lastActivity.getLastModifier() == null ? ANONYMOUS : lastActivity.getLastModifier().getName();
            builder.add((Object)this.addLongField("forumIndexPageLastActivityDate", lastActivityTime));
            builder.add((Object)this.addStringField("forumIndexLastActivityAuthor", lastActivityAuthorUsername));
        }
        return builder.build();
    }
}

