/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.view.macros.column.generic;

import com.adaptavist.confluence.forums.model.datatypes.DataItemType;
import com.adaptavist.confluence.forums.model.datatypes.DataTypeFormatter;
import com.adaptavist.confluence.forums.model.datatypes.DataTypeManager;
import com.adaptavist.confluence.forums.view.macros.AbstractForumMacro;
import com.adaptavist.confluence.forums.view.macros.aggregator.MacroServiceAggregator;
import com.adaptavist.confluence.forums.view.macros.velocity.builder.VelocityContextBuilder;
import com.adaptavist.confluence.support.LicensingSupport;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;

public class GenericColumnMacro
extends AbstractForumMacro {
    private DataTypeManager dataTypeManager;

    public GenericColumnMacro(@Qualifier(value="licensingSupport") LicensingSupport licensingSupport, MacroServiceAggregator macroServiceAggregator, DataTypeManager dataTypeManager) {
        super(licensingSupport, macroServiceAggregator);
        this.dataTypeManager = dataTypeManager;
    }

    @Override
    protected String getRenderedTemplateLocation() {
        return "forum/templates/vm/rest-forum-column-macro.vm";
    }

    @Override
    public String executeInternal(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        String columnName = parameters.get("column");
        if (columnName == null) {
            throw new MacroExecutionException("com.adaptavist.forums.genericcolumn.column.required");
        }
        DataItemType dataItemType = this.dataTypeManager.getDataItemType(columnName);
        if (dataItemType == null) {
            throw new MacroExecutionException("com.adaptavist.forums.genericcolumn.column.invalid");
        }
        DataTypeFormatter formatter = this.dataTypeManager.getDataTypeFormatter(dataItemType.getFormatterName());
        String format = parameters.get("format");
        if (format == null && formatter != null) {
            format = formatter.getDefaultFormat();
        }
        if (formatter == null || !formatter.hasPredefinedFormat(format)) {
            throw new MacroExecutionException(this.getText("com.adaptavist.confluence.restforum.columnmacro.invalid.formatter", format, columnName));
        }
        String heading = parameters.get("heading");
        if (heading == null) {
            heading = formatter.getDefaultFormat();
        }
        if (formatter.getResourceKey() != null) {
            this.getWebResourceManager().requireResource(formatter.getResourceKey());
        }
        VelocityContextBuilder contextBuilder = VelocityContextBuilder.contextBuilder().put("datatype", dataItemType.getName()).put("format", formatter.getFormatFor(format)).put("heading", heading);
        return this.resolveTemplate(this.getRenderedTemplateLocation()).withContext(contextBuilder);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

