/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.search.results.impl;

import com.adaptavist.confluence.forums.service.search.results.SearchResultAccessor;
import com.adaptavist.confluence.forums.service.search.results.SearchResultAccessors;
import com.adaptavist.confluence.forums.service.search.results.impl.DefaultSearchResultAccessor;
import com.adaptavist.confluence.forums.service.search.results.impl.DefaultSearchResultAccessors;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchResultAccessorFactory {
    private UserAccessor userAccessor;

    @Autowired
    public SearchResultAccessorFactory(@ComponentImport UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public SearchResultAccessor getAccessor(SearchResult searchResult) {
        return new DefaultSearchResultAccessor(this.userAccessor, searchResult);
    }

    public SearchResultAccessors getAccessors(SearchResults searchResults) {
        if (searchResults == null || searchResults.size() == 0 && searchResults.getUnfilteredResultsCount() == 0) {
            return DefaultSearchResultAccessors.EMPTY_RESULT_ACCESSORS;
        }
        ArrayList<SearchResultAccessor> resultAccessors = new ArrayList<SearchResultAccessor>(searchResults.size());
        for (SearchResult searchResult : searchResults) {
            resultAccessors.add(this.getAccessor(searchResult));
        }
        return new DefaultSearchResultAccessors(resultAccessors, searchResults.getUnfilteredResultsCount());
    }
}

