/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.search.impl;

import com.adaptavist.confluence.forums.model.module.impl.SearchKeysIndexMapperModuleDescriptor;
import com.adaptavist.confluence.forums.service.search.SearchKeyIndexResolver;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class DefaultSearchKeyIndexResolver
implements SearchKeyIndexResolver {
    private final PluginAccessor pluginAccessor;
    private Map<String, Set<String>> indexToSearchKeys;
    private Map<String, String> searchKeyToIndex;

    public DefaultSearchKeyIndexResolver(@ComponentImport PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public void flushCaches() {
        this.indexToSearchKeys = null;
        this.searchKeyToIndex = null;
    }

    private void addMappings(Map<String, Set<String>> mappings) {
        for (Map.Entry<String, Set<String>> mapping : mappings.entrySet()) {
            if (!StringUtils.isNotBlank((String)mapping.getKey()) || !CollectionUtils.isNotEmpty((Collection)mapping.getValue())) continue;
            this.indexToSearchKeys.put(mapping.getKey(), mapping.getValue());
            this.putValueForEach(this.searchKeyToIndex, mapping.getValue(), mapping.getKey());
        }
    }

    private void loadKeys() {
        if (this.indexToSearchKeys == null) {
            this.indexToSearchKeys = new HashMap<String, Set<String>>();
            this.searchKeyToIndex = new HashMap<String, String>();
            List modules = this.pluginAccessor.getEnabledModuleDescriptorsByClass(SearchKeysIndexMapperModuleDescriptor.class);
            for (SearchKeysIndexMapperModuleDescriptor module : modules) {
                this.addMappings(module.getMappings());
            }
        }
    }

    @Override
    public String resolveIndex(String searchKey) {
        this.loadKeys();
        return this.searchKeyToIndex.get(searchKey);
    }

    @Override
    public Set<String> resolveIndexes(Set<String> searchKeys) {
        this.loadKeys();
        HashSet<String> indexFields = new HashSet<String>();
        for (String searchKey : searchKeys) {
            if (!this.hasIndex(searchKey)) continue;
            indexFields.add(this.searchKeyToIndex.get(searchKey));
        }
        return indexFields;
    }

    @Override
    public boolean hasIndex(String searchKey) {
        this.loadKeys();
        return this.searchKeyToIndex.containsKey(searchKey);
    }

    @Override
    public boolean hasIndexes(Set<String> searchKeys) {
        this.loadKeys();
        return this.searchKeyToIndex.keySet().containsAll(searchKeys);
    }

    @Override
    public Set<String> getSearchKeys(String index) {
        this.loadKeys();
        return Collections.unmodifiableSet(this.indexToSearchKeys.get(index));
    }

    @Override
    public Set<String> getAllSearchKeys() {
        this.loadKeys();
        return Collections.unmodifiableSet(this.searchKeyToIndex.keySet());
    }

    private void putValueForEach(Map<String, String> map, Set<String> searchKeys, String indexKey) {
        for (String searchKey : searchKeys) {
            Set<String> indexKeySearchKeys = this.indexToSearchKeys.get(map.get(searchKey));
            if (indexKeySearchKeys != null && indexKeySearchKeys.contains(searchKey)) {
                throw new IllegalArgumentException("Duplicates search key mapping '" + searchKey + "'");
            }
            if (!StringUtils.isNotBlank((String)searchKey) || map.containsKey(searchKey)) continue;
            map.put(searchKey, indexKey);
        }
    }
}

