/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.search.impl;

import com.adaptavist.confluence.forums.service.ForumManager;
import com.adaptavist.confluence.forums.service.search.ForumSearchManager;
import com.adaptavist.confluence.forums.service.search.SearchManagerDelegate;
import com.adaptavist.confluence.forums.service.search.criteria.SearchCriteriaConversionManager;
import com.adaptavist.confluence.forums.service.search.exception.InvalidSearchQueryException;
import com.adaptavist.confluence.forums.service.search.results.SearchResultAccessor;
import com.adaptavist.confluence.forums.service.search.results.SearchResultAccessors;
import com.adaptavist.confluence.forums.service.search.results.SearchResultsConverter;
import com.adaptavist.confluence.forums.view.beans.ForumDirectory;
import com.adaptavist.confluence.forums.view.beans.ForumStatusUpdate;
import com.adaptavist.confluence.forums.view.beans.RecentForum;
import com.adaptavist.confluence.forums.view.beans.search.SearchCriteria;
import com.adaptavist.confluence.forums.view.beans.search.content.ContentSearchCriteria;
import com.adaptavist.confluence.forums.view.beans.search.content.ContentSearchCriteriaBuilder;
import com.adaptavist.confluence.forums.view.beans.search.content.ForumContentSearchResults;
import com.adaptavist.confluence.forums.view.beans.search.content.TopicContentSearchResults;
import com.adaptavist.confluence.forums.view.beans.search.topics.TopicSearchCriteria;
import com.adaptavist.confluence.forums.view.beans.search.topics.TopicSearchCriteriaBuilder;
import com.adaptavist.confluence.forums.view.beans.search.topics.TopicSearchResults;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewed;
import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewedManager;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DefaultForumSearchManager
implements ForumSearchManager {
    private final SearchManagerDelegate searchManager;
    private final SearchResultsConverter resultsConverter;
    private final SearchCriteriaConversionManager criteriaConversionManager;
    private final RecentlyViewedManager recentlyViewedManager;
    private PluginSettings pluginSettings;
    private PageManager pageManager;
    private PermissionManager permissionManager;
    private final ForumManager forumManager;

    @Autowired
    public DefaultForumSearchManager(SearchManagerDelegate searchManager, SearchResultsConverter resultsConverter, SearchCriteriaConversionManager criteriaConversionManager, RecentlyViewedManager recentlyViewedManager, PluginSettingsFactory pluginSettingsFactory, @Qualifier(value="pageManager") PageManager pageManager, @ComponentImport PermissionManager permissionManager, ForumManager forumManager) {
        this.searchManager = searchManager;
        this.resultsConverter = resultsConverter;
        this.criteriaConversionManager = criteriaConversionManager;
        this.recentlyViewedManager = recentlyViewedManager;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.forumManager = forumManager;
    }

    @Override
    public TopicSearchResults searchTopics(TopicSearchCriteria searchCriteria) throws InvalidSearchQueryException {
        return this.resultsConverter.topicResults(this.searchContent(searchCriteria), searchCriteria);
    }

    @Override
    public ForumStatusUpdate getForumStatusUpdate(TopicSearchCriteria searchCriteria) throws InvalidSearchQueryException {
        return this.resultsConverter.getForumStatusUpdate(this.searchContent(searchCriteria), searchCriteria);
    }

    @Override
    public TopicContentSearchResults searchTopics(ContentSearchCriteria searchCriteria) throws InvalidSearchQueryException {
        return this.resultsConverter.topicResults(this.searchContent(searchCriteria), searchCriteria.getStartIndex());
    }

    @Override
    public ForumContentSearchResults searchForums(ContentSearchCriteria searchCriteria) throws InvalidSearchQueryException {
        SearchResultAccessors results = this.searchContent(searchCriteria);
        Map<Long, SearchResultAccessors> forumTopics = this.doSearchForumTopics(results, searchCriteria.isRecursive());
        return this.resultsConverter.forumResults(results, searchCriteria.getStartIndex(), forumTopics);
    }

    @Override
    public SearchResultAccessors search(SearchQuery searchQuery) throws InvalidSearchQueryException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ContentSearch contentSearch = new ContentSearch(searchQuery, null, 0, Integer.MAX_VALUE);
        return this.searchManager.search(contentSearch);
    }

    @Override
    public SearchResultAccessors safeSearch(SearchQuery searchQuery) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ContentSearch contentSearch = new ContentSearch(searchQuery, null, 0, Integer.MAX_VALUE);
        return this.searchManager.safeSearch(contentSearch);
    }

    @Override
    public List<RecentForum> getRecentForums() throws InvalidSearchQueryException {
        int MAX_RESULTS = Integer.valueOf(this.pluginSettings.get("com.adaptavist.confluence.forums:forum-header-size").toString());
        int MAX_HISTORY_FETCH = 50;
        ArrayList<RecentForum> recentForums = new ArrayList<RecentForum>();
        List recentlyViewedPages = this.recentlyViewedManager.getRecentlyViewed(AuthenticatedUserThreadLocal.get().getKey().getStringValue(), 50);
        for (RecentlyViewed recentlyViewedPage : recentlyViewedPages) {
            if (this.forumManager.isForum(this.pageManager.getPage(recentlyViewedPage.getId()))) {
                recentForums.add(new RecentForum(recentlyViewedPage.getUrl(), recentlyViewedPage.getTitle()));
            }
            if (recentForums.size() != MAX_RESULTS) continue;
            break;
        }
        return recentForums;
    }

    @Override
    public List<ForumDirectory> getAllForumDirectory() throws InvalidSearchQueryException {
        ArrayList<ForumDirectory> allForums = new ArrayList<ForumDirectory>();
        SearchResultAccessors results = this.searchContent(ContentSearchCriteriaBuilder.allForumsContentCriteriaBuilder().build());
        for (SearchResultAccessor accessor : results) {
            Page page = this.pageManager.getPage(accessor.getId());
            if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)page)) continue;
            Space space = page.getSpace();
            allForums.add(new ForumDirectory(page.getUrlPath(), page.getTitle(), space.getUrlPath(), space.getName()));
        }
        return allForums;
    }

    @Override
    public boolean isForumHeaderOn() {
        return this.pluginSettings.get("com.adaptavist.confluence.forums:forum-header-on").toString().equals("1");
    }

    private SearchResultAccessors searchContent(SearchCriteria searchCriteria) throws InvalidSearchQueryException {
        ContentSearch topicContentSearch = this.convertToContentSearch(searchCriteria);
        return this.searchManager.search(topicContentSearch);
    }

    private Map<Long, SearchResultAccessors> doSearchForumTopics(SearchResultAccessors resultAccessors, boolean recursive) throws InvalidSearchQueryException {
        HashMap<Long, SearchResultAccessors> forumsTopicsMap = new HashMap<Long, SearchResultAccessors>();
        for (SearchResultAccessor accessor : resultAccessors) {
            long forumId = accessor.getId();
            TopicSearchCriteria searchCriteria = this.forumTopicsCriteria(forumId, recursive);
            forumsTopicsMap.put(forumId, this.searchManager.safeSearch(this.convertToContentSearch(searchCriteria)));
        }
        return forumsTopicsMap;
    }

    private ContentSearch convertToContentSearch(SearchCriteria searchCriteria) throws InvalidSearchQueryException {
        if (this.criteriaConversionManager.hasConverter(searchCriteria)) {
            return this.criteriaConversionManager.getConverter(searchCriteria).convertToContentSearch(searchCriteria);
        }
        throw new InvalidSearchQueryException("no search criteria found for " + searchCriteria.getClass());
    }

    private TopicSearchCriteria forumTopicsCriteria(long forumId, boolean recursive) {
        return TopicSearchCriteriaBuilder.topicCriteriaBuilder(forumId).maxPageSize().includeSubTopics(recursive).sortKey("lastactivitydate").build();
    }
}

