/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.jobs;

import com.adaptavist.confluence.forums.service.ActivityScoreManager;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityScoreUpdateJob
implements JobRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivityScoreUpdateJob.class);
    private final ActivityScoreManager activityScoreManager;

    @Autowired
    public ActivityScoreUpdateJob(ActivityScoreManager activityScoreManager) {
        this.activityScoreManager = activityScoreManager;
    }

    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
        LOGGER.debug("Starting to update outdated activity score");
        try {
            this.activityScoreManager.updateOutdatedActivityScores();
            LOGGER.debug("Finished updating outdated activity score");
        }
        catch (Exception e) {
            LOGGER.error("Error updating outdated activity score", (Throwable)e);
            return JobRunnerResponse.failed((String)"Update activity score failed");
        }
        return JobRunnerResponse.success((String)"Success");
    }
}

