/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.impl;

import com.adaptavist.confluence.forums.service.ForumPrefsManager;
import com.adaptavist.confluence.forums.view.beans.prefs.DisplayPrefs;
import com.adaptavist.confluence.forums.view.beans.prefs.FilterDateOption;
import com.adaptavist.confluence.forums.view.beans.prefs.FilterOption;
import com.adaptavist.confluence.forums.view.beans.prefs.FilterPref;
import com.adaptavist.confluence.forums.view.beans.prefs.ForumPrefs;
import com.adaptavist.confluence.forums.view.beans.prefs.SearchPrefs;
import com.adaptavist.confluence.forums.view.beans.prefs.SortOption;
import com.adaptavist.confluence.forums.view.beans.prefs.SortPrefs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultForumPrefsManager
implements ForumPrefsManager {
    private final I18nResolver i18nResolver;
    private final Map<String, Map<String, String>> prefsMap = new HashMap<String, Map<String, String>>();

    @Autowired
    public DefaultForumPrefsManager(@ComponentImport I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    @Override
    public ForumPrefs getDefaultForumPrefs() {
        return this.getForumPrefs(this.getSearchPrefs(), this.getSortPrefs(), this.getFilterPrefs(), this.getDisplayPrefs());
    }

    @Override
    public ForumPrefs getForumPrefs(SearchPrefs searchPrefs, SortPrefs sortPrefs, List<FilterPref> filterPrefs, DisplayPrefs displayPrefs) {
        return new ForumPrefs(searchPrefs, sortPrefs, filterPrefs, displayPrefs);
    }

    @Override
    public SearchPrefs getSearchPrefs() {
        String searchTooltip = this.getField("com.adaptavist.confluence.restforum.search", "tooltip");
        String searchKeysValue = this.getField("com.adaptavist.confluence.restforum.search.searchKeys", "value");
        HashSet<String> searchKeys = new HashSet<String>(Arrays.asList(searchKeysValue.split("\\s*[,;]\\s*")));
        return new SearchPrefs(searchTooltip, searchKeys);
    }

    @Override
    public SortPrefs getSortPrefs() {
        String sortLabel = this.getLabel("com.adaptavist.confluence.restforum.sort.sortBy");
        String stickyOnTopValue = this.getValue("com.adaptavist.confluence.restforum.sort.stickyOnTop");
        String stickyOnTopLabel = this.getLabel("com.adaptavist.confluence.restforum.sort.stickyOnTop");
        ArrayList<SortOption> options = new ArrayList<SortOption>();
        for (String index : this.getIndexList("com.adaptavist.confluence.restforum.sort.option")) {
            String sortOptionKey = this.getField("com.adaptavist.confluence.restforum.sort.option", index, "key");
            String sortOptionOrder = this.getField("com.adaptavist.confluence.restforum.sort.option", index, "order");
            String sortOptionLabel = this.getField("com.adaptavist.confluence.restforum.sort.option", index, "label");
            options.add(new SortOption(sortOptionKey, sortOptionOrder, sortOptionLabel));
        }
        return new SortPrefs(sortLabel, Boolean.valueOf(stickyOnTopValue), stickyOnTopLabel, options);
    }

    @Override
    public List<FilterPref> getFilterPrefs() {
        ArrayList<FilterPref> filterPrefs = new ArrayList<FilterPref>();
        List<String> filterIndexList = this.getIndexList("com.adaptavist.confluence.restforum.filter");
        for (String filterIndex : filterIndexList) {
            String filterKey = this.getField("com.adaptavist.confluence.restforum.filter", filterIndex, "key");
            String filterLabel = this.getField("com.adaptavist.confluence.restforum.filter", filterIndex, "label");
            String filterValueType = this.getField("com.adaptavist.confluence.restforum.filter", filterIndex, "value.type");
            String filterOptionPrefix = this.getPrefixFrom("com.adaptavist.confluence.restforum.filter", filterIndex, "option");
            ArrayList<FilterOption> filterOptions = new ArrayList<FilterOption>();
            for (String optionIndex : this.getIndexList(filterOptionPrefix)) {
                String optionLabel = this.getField(filterOptionPrefix, optionIndex, "label");
                String optionValue = this.getField(filterOptionPrefix, optionIndex, "value");
                if ("DATE".equalsIgnoreCase(filterValueType) && StringUtils.isNotBlank((String)optionValue)) {
                    filterOptions.add(new FilterDateOption(optionLabel, optionValue));
                    continue;
                }
                filterOptions.add(new FilterOption(optionLabel, optionValue));
            }
            filterPrefs.add(new FilterPref(filterKey, filterLabel, filterOptions));
        }
        return filterPrefs;
    }

    @Override
    public DisplayPrefs getDisplayPrefs() {
        String pageSizeLabel = this.getLabel("com.adaptavist.confluence.restforum.display.prefs.pageSize");
        String pageSizeValue = this.getValue("com.adaptavist.confluence.restforum.display.prefs.pageSize");
        return new DisplayPrefs(pageSizeValue, pageSizeLabel);
    }

    private Map<String, String> getPrefs(String prefix) {
        if (!this.prefsMap.containsKey(prefix)) {
            this.prefsMap.put(prefix, this.i18nResolver.getAllTranslationsForPrefix(prefix));
        }
        return this.prefsMap.get(prefix);
    }

    private int getCount(String prefix) {
        return this.getPrefs(prefix).size();
    }

    private List<String> getIndexList(String prefix) {
        Integer index = 1;
        ArrayList<String> indexList = new ArrayList<String>();
        while (this.getCount(this.getPrefixFrom(prefix, index.toString())) > 0) {
            indexList.add(index.toString());
            Integer n = index;
            index = index + 1;
        }
        return indexList;
    }

    private String getLabel(String keyPrefix) {
        return this.getField(keyPrefix, "label");
    }

    private String getValue(String keyPrefix) {
        return this.getField(keyPrefix, "value");
    }

    private String getField(String prefix, String ... fieldSelectors) {
        return this.i18nResolver.getText(this.getPrefixFrom(prefix, fieldSelectors));
    }

    private String getPrefixFrom(String prefix, String ... keySelectors) {
        StringBuilder key = new StringBuilder(prefix);
        for (String selector : keySelectors) {
            key.append(".").append(selector);
        }
        return key.toString();
    }
}

