/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.impl;

import com.adaptavist.confluence.forums.dao.ao.entity.PermissionsConfig;
import com.adaptavist.confluence.forums.dao.repository.PermissionsConfigRepository;
import com.adaptavist.confluence.forums.service.ForumManager;
import com.adaptavist.confluence.forums.service.analytic.event.AnalyticStrategy;
import com.adaptavist.confluence.forums.service.impl.PagePropertySupport;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.user.User;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultForumManager
implements ForumManager {
    private final AnalyticStrategy analyticStrategy;
    private final ConfluenceIndexer indexer;
    private final PageManager pageManager;
    private final PagePropertySupport propertySupport;
    private final PermissionsConfigRepository permissionsConfigRepository;
    private final PluginSettings pluginSettings;

    @Autowired
    public DefaultForumManager(AnalyticStrategy analyticStrategy, ConfluenceIndexer indexer, PageManager pageManager, PagePropertySupport pagePropertySupport, PermissionsConfigRepository permissionsConfigRepository, PluginSettingsFactory pluginSettingsFactory) {
        this.analyticStrategy = analyticStrategy;
        this.indexer = indexer;
        this.pageManager = pageManager;
        this.permissionsConfigRepository = permissionsConfigRepository;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.propertySupport = pagePropertySupport;
    }

    @Override
    public void createForum(Page rootPage) {
        this.markAsForum(rootPage);
        this.analyticStrategy.reportEventAnalytics((AbstractPage)rootPage, "Forum-Action", "Create-Forum");
    }

    @Override
    public void removeForum(Page rootPage) {
        this.removeForumFlag(rootPage);
    }

    @Override
    public void addIndexReference(Page rootPage, Page page) {
        String pageIdStr;
        String references = this.propertySupport.getStringProperty((AbstractPage)rootPage, "com.adaptavist.forum.FORUM_ROOT_PAGE_REFERENCES");
        String string = pageIdStr = rootPage.getId() != page.getId() ? String.valueOf(page.getId()) : String.valueOf(rootPage.getId());
        if (references == null || references.isEmpty()) {
            this.propertySupport.setStringProperty((AbstractPage)rootPage, "com.adaptavist.forum.FORUM_ROOT_PAGE_REFERENCES", pageIdStr);
        } else if (!references.contains(String.valueOf(page.getId()))) {
            references = references.concat(",").concat(pageIdStr);
            this.propertySupport.setStringProperty((AbstractPage)rootPage, "com.adaptavist.forum.FORUM_ROOT_PAGE_REFERENCES", references);
        }
    }

    @Override
    public void removeIndexReference(Page rootPage, Page page) {
        String references = this.propertySupport.getStringProperty((AbstractPage)rootPage, "com.adaptavist.forum.FORUM_ROOT_PAGE_REFERENCES");
        if (references != null && references.contains(String.valueOf(page.getId()))) {
            CharSequence[] refsArray = (String[])Arrays.stream(references.split(",")).filter(ref -> Long.parseLong(ref) != page.getId()).toArray(String[]::new);
            if (refsArray.length > 0) {
                this.propertySupport.setStringProperty((AbstractPage)rootPage, "com.adaptavist.forum.FORUM_ROOT_PAGE_REFERENCES", String.join((CharSequence)",", refsArray));
            } else {
                this.propertySupport.removePageProperty((AbstractPage)rootPage, "com.adaptavist.forum.FORUM_ROOT_PAGE_REFERENCES");
            }
        }
    }

    @Override
    public boolean hasIndexReference(Page rootPage) {
        return this.propertySupport.getStringProperty((AbstractPage)rootPage, "com.adaptavist.forum.FORUM_ROOT_PAGE_REFERENCES") != null && !this.propertySupport.getStringProperty((AbstractPage)rootPage, "com.adaptavist.forum.FORUM_ROOT_PAGE_REFERENCES").isEmpty();
    }

    @Override
    public void addTopic(AbstractPage topicPage) {
        this.markAsTopic(topicPage);
    }

    @Override
    public void removeTopic(AbstractPage topicPage) {
        this.removeTopicFlag(topicPage);
        this.pageManager.saveNewVersion((ContentEntityObject)topicPage, abstractPage -> {});
    }

    @Override
    public void unmarkChildrenAsTopic(AbstractPage forumPage) {
        for (AbstractPage abstractPage : this.propertySupport.getDescendants(forumPage)) {
            this.removeTopic(abstractPage);
        }
    }

    @Override
    public boolean isForum(Page page) {
        return this.hasForumFlag((AbstractPage)page);
    }

    @Override
    public boolean isSubForum(Page page) {
        return this.hasForumFlag((AbstractPage)page) && this.hasForumFlag(page.getAncestors());
    }

    @Override
    public boolean isPageFromLockedForum(AbstractPage page) {
        return this.propertySupport.isPagePropertySet(page, "com.adaptavist.forum.FORUM_PAGE_LOCKED_FORUM");
    }

    @Override
    public boolean hasCreateForumPermission(User user, Page page) {
        return this.propertySupport.getPermissionsSupport().hasEditPermission(user, page);
    }

    @Override
    public Page getForumForTopic(AbstractPage topicPage) {
        if (topicPage instanceof Page) {
            Page parent;
            for (parent = ((Page)topicPage).getParent(); parent != null && !this.hasForumFlag((AbstractPage)parent); parent = parent.getParent()) {
            }
            return parent;
        }
        return null;
    }

    @Override
    public boolean isTopic(AbstractPage page) {
        return page != null && !this.hasForumFlag(page) && this.hasTopicFlag(page);
    }

    @Override
    public boolean isNewPageEligableAsTopic(AbstractPage abstractPage) {
        return this.hasForumFlag(this.propertySupport.getAncestors(abstractPage)) && abstractPage.isNew() && !this.isParentForumLocked(abstractPage);
    }

    private void markAsForum(Page page) {
        this.propertySupport.addPageProperty((AbstractPage)page, "com.adaptavist.forum.FORUM_ROOT_PAGE");
        this.markAsTopic(this.propertySupport.getDescendants((AbstractPage)page));
    }

    private void removeForumFlag(Page page) {
        this.propertySupport.removePageProperty((AbstractPage)page, "com.adaptavist.forum.FORUM_ROOT_PAGE");
        this.removeTopicFlag(this.propertySupport.getDescendants((AbstractPage)page));
    }

    private void markAsTopic(AbstractPage page) {
        this.propertySupport.addPageProperty(page, "com.adaptavist.forum.FORUM_TOPIC_PAGE");
        this.analyticStrategy.reportEventAnalytics(page, "Topic-Action", "Topic-Added");
    }

    private void removeTopicFlag(AbstractPage page) {
        this.propertySupport.removePageProperty(page, "com.adaptavist.forum.FORUM_TOPIC_PAGE");
    }

    @Override
    public void markAsPageInLockedForum(Page page) {
        this.propertySupport.addPageProperty((AbstractPage)page, "com.adaptavist.forum.FORUM_PAGE_LOCKED_FORUM");
    }

    @Override
    public void unmarkAsPageInLockedForum(Page page) {
        this.propertySupport.removePageProperty((AbstractPage)page, "com.adaptavist.forum.FORUM_PAGE_LOCKED_FORUM");
    }

    @Override
    public void unmarkAsPageInLockedForum(AbstractPage abstractPage) {
        Page page = this.pageManager.getPage(abstractPage.getId());
        this.propertySupport.removePageProperty((AbstractPage)page, "com.adaptavist.forum.FORUM_PAGE_LOCKED_FORUM");
    }

    private boolean hasForumFlag(AbstractPage page) {
        return this.propertySupport.isPagePropertySet(page, "com.adaptavist.forum.FORUM_ROOT_PAGE");
    }

    private boolean hasTopicFlag(AbstractPage page) {
        return this.propertySupport.isPagePropertySet(page, "com.adaptavist.forum.FORUM_TOPIC_PAGE");
    }

    @Override
    public boolean hasForumFlag(List<Page> pages) {
        for (Page page : pages) {
            if (!this.hasForumFlag((AbstractPage)page)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void markAsTopic(List<Page> pages) {
        for (Page page : pages) {
            if (this.hasForumFlag((AbstractPage)page) || this.hasTopicFlag((AbstractPage)page)) continue;
            this.markAsTopic((AbstractPage)page);
        }
    }

    @Override
    public void removeTopicFlag(List<Page> pages) {
        for (Page page : pages) {
            if (!this.hasTopicFlag((AbstractPage)page)) continue;
            this.removeTopicFlag((AbstractPage)page);
        }
    }

    @Override
    public void updateHeaderConfiguration(boolean forumHeaderOn, boolean forumSummaryNotification, int forumHeaderSize) {
        this.pluginSettings.put("com.adaptavist.confluence.forums:forum-header-on", (Object)(forumHeaderOn ? "1" : "0"));
        this.pluginSettings.put("com.adaptavist.confluence.forums:forum-header-size", (Object)Integer.valueOf(forumHeaderSize).toString());
        this.pluginSettings.put("com.adaptavist.confluence.forums:forum-summary-notification", (Object)(forumSummaryNotification ? "1" : "0"));
    }

    @Override
    public boolean getForumHeaderOn() {
        return this.pluginSettings.get("com.adaptavist.confluence.forums:forum-header-on").toString().equals("1");
    }

    @Override
    public boolean getForumSummaryNotification() {
        Object summaryNotificationFlag = this.pluginSettings.get("com.adaptavist.confluence.forums:forum-summary-notification");
        return summaryNotificationFlag == null || summaryNotificationFlag.toString().equals("1");
    }

    @Override
    public int getForumHeaderSize() {
        return Integer.parseInt(this.pluginSettings.get("com.adaptavist.confluence.forums:forum-header-size").toString());
    }

    @Override
    public void lockPage(AbstractPage page) {
        this.propertySupport.addPageProperty(page, "com.adaptavist.confluence.forum.FORUM_PAGE_LOCKED");
        this.indexer.reIndex((Searchable)page);
    }

    @Override
    public void unlockPage(AbstractPage page) {
        this.propertySupport.removePageProperty(page, "com.adaptavist.confluence.forum.FORUM_PAGE_LOCKED");
        this.unlockPageDescendants(page);
    }

    @Override
    public boolean isPageLocked(AbstractPage page) {
        return this.propertySupport.isPagePropertySet(page, "com.adaptavist.confluence.forum.FORUM_PAGE_LOCKED");
    }

    @Override
    public boolean hasLockingPagePermission(User user, AbstractPage page) {
        PermissionsConfig.PermissionType permissionType = this.permissionsConfigRepository.getLockingPermissionsForSpace(this.propertySupport.getSpaceKey(page));
        return this.propertySupport.getPermissionsSupport().hasPermission(permissionType, user, page);
    }

    @Override
    public void unlockPageDescendants(AbstractPage abstractPage) {
        Page page = this.pageManager.getPage(abstractPage.getId());
        if (this.isForum(page)) {
            List descendants = page.getDescendants();
            for (Page child : descendants) {
                this.unmarkAsPageInLockedForum(child);
            }
        }
    }

    @Override
    public boolean isParentForumLocked(AbstractPage abstractPage) {
        Page page = this.pageManager.getPage(abstractPage.getId());
        return this.isParentForumLocked(page);
    }

    @Override
    public boolean isParentForumLocked(Page page) {
        List ancestors = page.getAncestors();
        for (Page parent : Lists.reverse((List)ancestors)) {
            if (!this.isForum(parent) || !this.isPageLocked((AbstractPage)parent)) continue;
            return true;
        }
        return false;
    }
}

