/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.extractors;

import com.adaptavist.confluence.forums.service.ForumManager;
import com.adaptavist.confluence.forums.service.extractors.AbstractForumExtractor;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.google.common.collect.ImmutableList;
import java.util.Collection;

public class LockedForumExtractor
extends AbstractForumExtractor {
    final ForumManager forumManager;

    public LockedForumExtractor(ForumManager forumManager) {
        this.forumManager = forumManager;
    }

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (searchable instanceof Page) {
            Page page = (Page)searchable;
            boolean pageLocked = this.forumManager.isPageLocked((AbstractPage)page);
            if (pageLocked) {
                builder.add((Object)this.addStringField("forumIndexPageIsLocked", String.valueOf(true)));
            }
            builder.add((Object)this.addStringField("forumIndexPageIsLockedInt", pageLocked ? "1" : "0"));
        }
        return builder.build();
    }
}

