/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.analytic.pluginevent;

import com.adaptavist.analytic.concurrent.ExecutorServiceManager;
import com.adaptavist.analytic.dispatcher.DispatchingFrequency;
import com.adaptavist.analytic.model.Analytic;
import com.adaptavist.analytic.model.SegmentTrackAnalytic;
import com.adaptavist.analytic.service.AnalyticService;
import com.adaptavist.confluence.forums.service.analytic.pluginevent.PluginEventMetrics;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;

public class AnalyticPluginEventListener {
    private static final String PLUGIN_KEY = "com.adaptavist.confluence.forums";
    private final AnalyticService analyticService;
    private final PluginEventMetrics pluginEventMetrics;
    private final ExecutorServiceManager executorServiceManager;

    public AnalyticPluginEventListener(AnalyticService analyticService, PluginEventMetrics pluginEventMetrics, @ComponentImport ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory) {
        this.analyticService = analyticService;
        this.executorServiceManager = new ExecutorServiceManager(threadLocalDelegateExecutorFactory);
        this.pluginEventMetrics = pluginEventMetrics;
    }

    @PluginEventListener
    public void trackAnalytic(PluginEvent pluginEvent) {
        this.executorServiceManager.getExecutorService().submit(() -> {
            if (pluginEvent.getPlugin().getKey().equals(PLUGIN_KEY)) {
                SegmentTrackAnalytic analytic = new SegmentTrackAnalytic(this.pluginEventMetrics.getSen(), "App-Change", this.pluginEventMetrics.getMetricsMap(pluginEvent.getClass().getSimpleName()), DispatchingFrequency.MINUTE);
                this.analyticService.track((Analytic)analytic);
            }
        });
    }
}

