/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.analytic;

import com.adaptavist.analytic.dispatcher.AnalyticDispatcher;
import com.adaptavist.analytic.dispatcher.SegmentAnalyticDispatcher;
import com.adaptavist.analytic.dispatcher.key.LicenseTypeKeyProvider;
import com.adaptavist.analytic.dispatcher.key.WriteKeyResolutionException;
import com.adaptavist.analytic.service.DefaultAnalyticService;
import com.adaptavist.analytic.setting.persistence.ActiveObjectAnalyticSettingPersistenceStrategy;
import com.adaptavist.analytic.setting.persistence.AnalyticSettingPersistenceStrategy;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.cache.CacheManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ForumsAnalyticService
extends DefaultAnalyticService {
    private static final Logger LOG = LoggerFactory.getLogger(ForumsAnalyticService.class);
    private static final String APP_NAME = System.getProperty("atlassian.plugin.key");

    @Autowired
    public ForumsAnalyticService(@ComponentImport EventPublisher eventPublisher, @ComponentImport ActiveObjects activeObjects, BundleContext bundleContext, @ComponentImport CacheManager cacheManager, @Qualifier(value="licenseTypeKeyProvider") LicenseTypeKeyProvider keyProvider, @ComponentImport ThreadLocalDelegateExecutorFactory threadLocalDelegate) {
        super(eventPublisher, ForumsAnalyticService.getDispatchers(keyProvider), (AnalyticSettingPersistenceStrategy)new ActiveObjectAnalyticSettingPersistenceStrategy(activeObjects), bundleContext, cacheManager, APP_NAME, threadLocalDelegate);
    }

    private static Set<AnalyticDispatcher> getDispatchers(LicenseTypeKeyProvider keyProvider) {
        SegmentAnalyticDispatcher dispatcher = null;
        try {
            dispatcher = new SegmentAnalyticDispatcher(keyProvider.getKey());
        }
        catch (WriteKeyResolutionException e) {
            LOG.warn("Unable to properly start the analytics for Community Forums for Confluence - there was a problem retrieving the write key");
        }
        return new HashSet<SegmentAnalyticDispatcher>(Collections.singletonList(dispatcher));
    }
}

