/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.listeners;

import com.adaptavist.confluence.forums.service.ForumManager;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.page.PageViewEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import org.springframework.beans.factory.DisposableBean;

public class PageViewEventListener
implements DisposableBean {
    private final ConfluenceIndexer indexer;
    private final ForumManager forumManager;
    private final EventPublisher eventPublisher;

    public PageViewEventListener(ConfluenceIndexer indexer, ForumManager forumManager, EventPublisher eventPublisher) {
        this.indexer = indexer;
        this.forumManager = forumManager;
        this.eventPublisher = eventPublisher;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void pageViewEvent(PageViewEvent pageViewEvent) {
        ContentEntityObject contentEntityObject = pageViewEvent.getContent();
        if (this.isTopic(contentEntityObject)) {
            this.indexer.reIndex((Searchable)contentEntityObject);
        }
    }

    private boolean isTopic(ContentEntityObject entityObject) {
        return entityObject instanceof AbstractPage && this.forumManager.isTopic((AbstractPage)entityObject);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

