/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.listeners;

import com.adaptavist.confluence.forums.service.ForumManager;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.attachment.AttachmentCreateEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentRemoveEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.DisposableBean;

public class PageAttachmentEventListener
implements DisposableBean {
    private final ConfluenceIndexer indexer;
    private final ForumManager forumManager;
    private final EventPublisher eventPublisher;

    public PageAttachmentEventListener(ConfluenceIndexer indexer, ForumManager forumManager, @ComponentImport EventPublisher eventPublisher) {
        this.indexer = indexer;
        this.forumManager = forumManager;
        this.eventPublisher = eventPublisher;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void createAttachmentEvent(AttachmentCreateEvent createdEvent) {
        ContentEntityObject contentEntityObject = createdEvent.getContent();
        if (this.isTopic(contentEntityObject)) {
            this.indexer.reIndex((Searchable)contentEntityObject);
        }
    }

    @EventListener
    public void removeAttachmentEvent(AttachmentRemoveEvent removeEvent) {
        ContentEntityObject contentEntityObject = removeEvent.getContent();
        if (this.isTopic(contentEntityObject)) {
            this.indexer.reIndex((Searchable)contentEntityObject);
        }
    }

    private boolean isTopic(ContentEntityObject entityObject) {
        return entityObject instanceof AbstractPage && this.forumManager.isTopic((AbstractPage)entityObject);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

