function createSelect2ForTemplatePage() {
    AJS.$("#template-page").auiSelect2({
        placeholder: ' ', //work around to make allowClear work as it is dependant on placeholder
        allowClear: true,
        minimumInputLength: 1,

        initSelection: function (element, callback) {
            var data = {id: element.get("0").attributes.templateId.value, text: element.get("0").value};
            return callback(data);
        },

        ajax: {
            url: AJS.Meta.get("context-path") + '/rest/forums/latest/template',
            dataType: 'json',
            type: "GET",
            quietMillis: 350,
            data: function (term) {
                return {
                    templateName: term,
                    spaceKey: AJS.params.spaceKey
                };
            },
            results: function (data) {
                return {
                    results: $.map(data, function (template) {
                        return {
                            id: template.templateId,
                            text: template.templateTitle
                        }
                    })
                }
            }
        }
    });
}