/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.validation.impl;

import com.adaptavist.confluence.forums.service.ForumManager;
import com.adaptavist.confluence.forums.service.impl.PermissionsSupport;
import com.adaptavist.confluence.forums.service.validation.ValidationReport;
import com.adaptavist.confluence.forums.service.validation.Validator;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ViewPageStatusValidator
implements Validator<AbstractPage> {
    private final ForumManager forumManager;
    private final PermissionsSupport permissionsSupport;

    @Autowired
    public ViewPageStatusValidator(ForumManager forumManager, PermissionsSupport permissionsSupport) {
        this.forumManager = forumManager;
        this.permissionsSupport = permissionsSupport;
    }

    @Override
    public ValidationReport validate(AbstractPage page) {
        if (page == null) {
            return ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.resource.page.not.found", new Serializable[0]);
        }
        if (!this.isForumOrTopic(page)) {
            return ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.resource.pages.not.forum.page", new Serializable[0]);
        }
        if (!this.permissionsSupport.hasViewPagePermission((User)AuthenticatedUserThreadLocal.get(), page)) {
            return ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.resource.pages.view.status.permissions", new Serializable[0]);
        }
        return ValidationReport.success();
    }

    private boolean isForumOrTopic(AbstractPage page) {
        return this.forumManager.isTopic(page) || page instanceof Page && this.forumManager.isForum((Page)page);
    }
}

