/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.search.impl;

import com.adaptavist.confluence.forums.service.search.SearchManagerDelegate;
import com.adaptavist.confluence.forums.service.search.exception.InvalidSearchQueryException;
import com.adaptavist.confluence.forums.service.search.results.SearchResultAccessors;
import com.adaptavist.confluence.forums.service.search.results.impl.DefaultSearchResultAccessors;
import com.adaptavist.confluence.forums.service.search.results.impl.SearchResultAccessorFactory;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultSearchManagerDelegate
implements SearchManagerDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSearchManagerDelegate.class);
    private final SearchManager searchManager;
    private final SearchResultAccessorFactory accessorFactory;

    @Autowired
    public DefaultSearchManagerDelegate(SearchManager searchManager, SearchResultAccessorFactory accessorFactory) {
        this.searchManager = searchManager;
        this.accessorFactory = accessorFactory;
    }

    @Override
    public SearchResultAccessors search(ContentSearch contentSearch) throws InvalidSearchQueryException {
        try {
            SearchResults searchResults = this.searchManager.search((ISearch)contentSearch);
            return this.accessorFactory.getAccessors(searchResults);
        }
        catch (InvalidSearchException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new InvalidSearchQueryException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new InvalidSearchQueryException(e.getMessage(), e);
        }
    }

    @Override
    public SearchResultAccessors safeSearch(ContentSearch contentSearch) {
        try {
            return this.search(contentSearch);
        }
        catch (InvalidSearchQueryException e) {
            return DefaultSearchResultAccessors.EMPTY_RESULT_ACCESSORS;
        }
    }
}

