/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.extractors;

import com.adaptavist.confluence.forums.service.extractors.AbstractForumExtractor;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class AncestorsForumExtractor
extends AbstractForumExtractor {
    public Collection<FieldDescriptor> extractFields(Object searchable) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (searchable instanceof Page) {
            Page page = (Page)searchable;
            String parentId = this.getParentId(page);
            Set<String> ancestors = this.getAncestorsIds(page);
            builder.add((Object)this.addStringField("forumIndexPageParentId", parentId));
            ancestors.forEach(ancestor -> builder.add((Object)this.addStringField("forumIndexPageAncestorIds", (String)ancestor)));
        }
        return builder.build();
    }

    private String getParentId(Page page) {
        return page.getParent() != null ? page.getParent().getIdAsString() : null;
    }

    private Set<String> getAncestorsIds(Page page) {
        HashSet<String> ids = new HashSet<String>(page.getAncestors().size());
        for (Page ancestor : page.getAncestors()) {
            ids.add(ancestor.getIdAsString());
        }
        return ids;
    }
}

