/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.analytic.event;

import com.adaptavist.analytic.event.listener.MissingListenerException;
import com.adaptavist.analytic.service.AnalyticService;
import com.adaptavist.confluence.forums.service.analytic.listener.AnalyticEventListenerManager;
import com.adaptavist.confluence.forums.service.analytic.pluginevent.AnalyticPluginEventListener;
import com.adaptavist.confluence.forums.service.analytic.pluginevent.PluginEventMetrics;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class AnalyticListenerInitialiser
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticListenerInitialiser.class);
    private AnalyticService analyticService;
    private AnalyticEventListenerManager analyticEventListenerManager;
    private ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory;
    private PluginEventMetrics pluginEventMetrics;

    public AnalyticListenerInitialiser(AnalyticEventListenerManager analyticEventListenerManager, AnalyticService analyticService, PluginEventMetrics pluginEventMetrics, ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory) {
        this.analyticEventListenerManager = analyticEventListenerManager;
        this.analyticService = analyticService;
        this.pluginEventMetrics = pluginEventMetrics;
        this.threadLocalDelegateExecutorFactory = threadLocalDelegateExecutorFactory;
    }

    public void afterPropertiesSet() {
        block2: {
            try {
                this.analyticEventListenerManager.addEventListener(new AnalyticPluginEventListener(this.analyticService, this.pluginEventMetrics, this.threadLocalDelegateExecutorFactory));
                this.analyticEventListenerManager.registerListeners();
            }
            catch (MissingListenerException e) {
                LOG.warn("An unexpected error occurred whilst initialising listeners for analytics in Community Forums.");
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Exception:", (Throwable)e);
            }
        }
    }
}

