/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.listeners.handler.impl;

import com.adaptavist.confluence.forums.controller.listeners.handler.impl.PageEventAbstractStrategy;
import com.adaptavist.confluence.forums.service.ForumManager;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MovePageEventStrategy
extends PageEventAbstractStrategy<PageMoveEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(MovePageEventStrategy.class);
    private final ForumManager forumManager;

    public MovePageEventStrategy(ForumManager forumManager) {
        this.forumManager = forumManager;
    }

    @Override
    public void processPageEvent(PageMoveEvent pageEvent) {
        Page originalPage = this.getPage((PageEvent)pageEvent);
        Page newParentPage = pageEvent.getNewParentPage();
        if (this.forumManager.isTopic((AbstractPage)originalPage) && !this.forumManager.isForum(newParentPage)) {
            this.forumManager.removeTopic((AbstractPage)originalPage);
            LOG.info("Forum flags removed after page " + originalPage.getId() + " has been moved");
        } else if (!this.forumManager.isTopic((AbstractPage)originalPage) && this.forumManager.isForum(newParentPage) && !this.forumManager.isParentForumLocked(originalPage)) {
            this.forumManager.addTopic((AbstractPage)originalPage);
            LOG.info("Forum flags added after page " + originalPage.getId() + " has been moved");
        }
    }
}

