/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.action.config;

import com.adaptavist.confluence.forums.controller.action.AbstractLicensedAdminAction;
import com.adaptavist.confluence.forums.dao.ao.builder.ActivityScoreConfigBuilder;
import com.adaptavist.confluence.forums.dao.ao.builder.PermissionsConfigBuilder;
import com.adaptavist.confluence.forums.dao.ao.entity.ActivityScoreConfig;
import com.adaptavist.confluence.forums.dao.ao.entity.PermissionsConfig;
import com.adaptavist.confluence.forums.dao.repository.ActivityScoreConfigRepository;
import com.adaptavist.confluence.forums.dao.repository.PermissionsConfigRepository;
import com.adaptavist.confluence.forums.service.ForumManager;
import com.atlassian.xwork.ParameterSafe;
import com.atlassian.xwork.RequireSecurityToken;
import org.apache.commons.lang.StringUtils;

public class GlobalConfigurationAction
extends AbstractLicensedAdminAction {
    private boolean stickySpaceOverride;
    private boolean lockingSpaceOverride;
    private boolean forumHeaderOn;
    private boolean forumSummaryNotification;
    private int forumHeaderSize;
    private PermissionsConfigBuilder permissionsBuilder;
    private ActivityScoreConfigBuilder activityScoreBuilder;
    private PermissionsConfigRepository permissionsService;
    private ActivityScoreConfigRepository activityScoreService;
    private ForumManager forumManager;

    @ParameterSafe
    public String getGlobalConfiguration() {
        if (this.isLicensed()) {
            this.loadConfiguration();
            return "success";
        }
        return "pluginlicenseexpired";
    }

    @ParameterSafe
    @RequireSecurityToken(value=true)
    public String updateGlobalPermissions() {
        this.permissionsBuilder.withStickySpaceOverride(this.stickySpaceOverride);
        this.permissionsBuilder.withLockingSpaceOverride(this.lockingSpaceOverride);
        PermissionsConfig savedConfig = this.permissionsService.saveGlobalPermissions(this.permissionsBuilder);
        this.permissionsBuilder = PermissionsConfigBuilder.globalPermissionsBuilderFrom(savedConfig);
        this.stickySpaceOverride = this.permissionsBuilder.isStickySpaceOverride();
        this.lockingSpaceOverride = this.permissionsBuilder.isLockingSpaceOverride();
        return "success";
    }

    @ParameterSafe
    @RequireSecurityToken(value=true)
    public String updateGlobalActivityScoreConfig() {
        ActivityScoreConfig savedConfig = this.activityScoreService.saveGlobalActivityScoreConfig(this.activityScoreBuilder);
        this.activityScoreBuilder = ActivityScoreConfigBuilder.globalActivityScoreBuilderFrom(savedConfig);
        return "success";
    }

    @ParameterSafe
    @RequireSecurityToken(value=true)
    public String updateHeaderConfiguration() {
        this.forumManager.updateHeaderConfiguration(this.forumHeaderOn, this.forumSummaryNotification, this.forumHeaderSize);
        return "success";
    }

    @ParameterSafe
    public boolean getForumHeaderOn() {
        return this.forumManager.getForumHeaderOn();
    }

    @ParameterSafe
    public void setForumHeaderOn(boolean forumHeaderOn) {
        this.forumHeaderOn = forumHeaderOn;
    }

    @ParameterSafe
    public boolean getForumSummaryNotification() {
        return this.forumManager.getForumSummaryNotification();
    }

    @ParameterSafe
    public void setForumSummaryNotification(boolean forumSummaryNotification) {
        this.forumSummaryNotification = forumSummaryNotification;
    }

    @ParameterSafe
    public int getForumHeaderSize() {
        return this.forumManager.getForumHeaderSize();
    }

    @ParameterSafe
    public void setForumHeaderSize(int forumHeaderSize) {
        this.forumHeaderSize = forumHeaderSize;
    }

    @ParameterSafe
    public String getStickyPermission() {
        return this.getPermissionsBuilder().getStickyPermission().name();
    }

    @ParameterSafe
    public void setStickyPermission(String stickyPermission) {
        PermissionsConfig.PermissionType permission = PermissionsConfig.PermissionType.fromString(stickyPermission);
        if (permission != null) {
            this.getPermissionsBuilder().withStickyPermission(permission);
        }
    }

    @ParameterSafe
    public String getLockingPermission() {
        return this.getPermissionsBuilder().getLockingPermission().name();
    }

    @ParameterSafe
    public void setLockingPermission(String lockingPermission) {
        PermissionsConfig.PermissionType permission = PermissionsConfig.PermissionType.fromString(lockingPermission);
        if (permission != null) {
            this.getPermissionsBuilder().withLockingPermission(permission);
        }
    }

    @ParameterSafe
    public boolean isStickySpaceOverride() {
        return this.stickySpaceOverride;
    }

    @ParameterSafe
    public void setStickySpaceOverride(boolean stickySpaceOverride) {
        this.stickySpaceOverride = stickySpaceOverride;
    }

    @ParameterSafe
    public boolean isLockingSpaceOverride() {
        return this.lockingSpaceOverride;
    }

    @ParameterSafe
    public void setLockingSpaceOverride(boolean lockingSpaceOverride) {
        this.lockingSpaceOverride = lockingSpaceOverride;
    }

    @ParameterSafe
    public String getEditMultiplier() {
        return String.valueOf(this.getActivityScoreBuilder().getEditMultiplier());
    }

    @ParameterSafe
    public void setEditMultiplier(String editMultiplier) {
        Integer multiplier = this.getMultiplier(editMultiplier);
        if (multiplier != null) {
            this.getActivityScoreBuilder().withEditMultiplier(multiplier);
        }
    }

    @ParameterSafe
    public String getCommentMultiplier() {
        return String.valueOf(this.getActivityScoreBuilder().getCommentMultiplier());
    }

    @ParameterSafe
    public void setCommentMultiplier(String commentMultiplier) {
        Integer multiplier = this.getMultiplier(commentMultiplier);
        if (multiplier != null) {
            this.getActivityScoreBuilder().withCommentMultiplier(multiplier);
        }
    }

    @ParameterSafe
    public String getAttachmentMultiplier() {
        return String.valueOf(this.getActivityScoreBuilder().getAttachmentMultiplier());
    }

    @ParameterSafe
    public void setAttachmentMultiplier(String attachmentMultiplier) {
        Integer multiplier = this.getMultiplier(attachmentMultiplier);
        if (multiplier != null) {
            this.getActivityScoreBuilder().withAttachmentMultiplier(multiplier);
        }
    }

    @ParameterSafe
    public String getContentAge() {
        return this.getActivityScoreBuilder().getContentAge().name();
    }

    @ParameterSafe
    public void setContentAge(String contentAge) {
        ActivityScoreConfig.ContentAge multiplier = ActivityScoreConfig.ContentAge.fromString(contentAge);
        if (multiplier != null) {
            this.getActivityScoreBuilder().withContentAge(multiplier);
        }
    }

    private void loadConfiguration() {
        PermissionsConfig permissions = this.permissionsService.getGlobalPermissions();
        ActivityScoreConfig activityScore = this.activityScoreService.getOrCreateGlobalActivityScoreConfig();
        this.permissionsBuilder = PermissionsConfigBuilder.globalPermissionsBuilderFrom(permissions);
        this.stickySpaceOverride = this.permissionsBuilder.isStickySpaceOverride();
        this.lockingSpaceOverride = this.permissionsBuilder.isLockingSpaceOverride();
        this.activityScoreBuilder = ActivityScoreConfigBuilder.globalActivityScoreBuilderFrom(activityScore);
    }

    private PermissionsConfigBuilder getPermissionsBuilder() {
        if (this.permissionsBuilder == null) {
            this.permissionsBuilder = PermissionsConfigBuilder.globalPermissionsBuilderFrom(this.permissionsService.getGlobalPermissions());
        }
        return this.permissionsBuilder;
    }

    private ActivityScoreConfigBuilder getActivityScoreBuilder() {
        if (this.activityScoreBuilder == null) {
            this.activityScoreBuilder = ActivityScoreConfigBuilder.globalActivityScoreBuilderFrom(this.activityScoreService.getOrCreateGlobalActivityScoreConfig());
        }
        return this.activityScoreBuilder;
    }

    private Integer getMultiplier(String multiplier) {
        String trimmed = StringUtils.trim((String)multiplier);
        try {
            return Integer.parseInt(trimmed);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @ParameterSafe
    public void setForumPermissionsService(PermissionsConfigRepository permissionsConfigService) {
        this.permissionsService = permissionsConfigService;
    }

    @ParameterSafe
    public void setForumActivityScoreService(ActivityScoreConfigRepository activityScoreConfigService) {
        this.activityScoreService = activityScoreConfigService;
    }

    @ParameterSafe
    public void setForumManager(ForumManager forumManager) {
        this.forumManager = forumManager;
    }
}

