/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.view.macros;

import com.adaptavist.confluence.forums.view.macros.AbstractLicensedMacro;
import com.adaptavist.confluence.forums.view.macros.aggregator.MacroServiceAggregator;
import com.adaptavist.confluence.forums.view.macros.params.ParamsParser;
import com.adaptavist.confluence.forums.view.macros.velocity.VelocityTemplateResolver;
import com.adaptavist.confluence.forums.view.macros.velocity.builder.VelocityContextBuilder;
import com.adaptavist.confluence.support.LicensingSupport;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractForumMacro
extends AbstractLicensedMacro {
    protected static final String REST_FORUM_ERROR_TEMPLATE = "forum/templates/vm/rest-forum-error.vm";
    protected static final String PARAM_ERROR_TITLE = "errorTitle";
    protected static final String PARAM_ERROR_MESSAGE = "errorMessage";
    protected static final String MACRO_NAME = "macroName";
    private MacroServiceAggregator serviceAggregator;

    public AbstractForumMacro(LicensingSupport licensingSupport, MacroServiceAggregator macroServiceAggregator) {
        super(licensingSupport);
        this.serviceAggregator = macroServiceAggregator;
    }

    protected abstract String getRenderedTemplateLocation();

    public I18nResolver getI18nResolver() {
        return this.serviceAggregator.getI18nResolver();
    }

    public VelocityTemplateResolver getTemplateResolver() {
        return this.serviceAggregator.getVelocityTemplateResolver();
    }

    protected VelocityTemplateResolver.VelocityTemplateRenderer resolveTemplate(String templatePath) {
        return this.getTemplateResolver().resolveTemplate(templatePath);
    }

    protected WebResourceManager getWebResourceManager() {
        return this.serviceAggregator.getWebResourceManager();
    }

    protected PermissionManager getPermissionManager() {
        return this.serviceAggregator.getPermissionManager();
    }

    protected PageManager getPageManager() {
        return this.serviceAggregator.getPageManager();
    }

    protected ParamsParser getParamsParser() {
        return this.serviceAggregator.getParamsParser();
    }

    protected String getText(String key, String ... args) {
        return this.getI18nResolver().getText(key, (Serializable[])args);
    }

    protected boolean getBooleanParam(String paramName, Map<String, String> parameters, boolean defaultValue) {
        return Boolean.parseBoolean(this.getParam(paramName, parameters, String.valueOf(defaultValue)));
    }

    protected int getIntParam(String paramName, Map<String, String> parameters, int defaultValue) {
        return Integer.parseInt(this.getParam(paramName, parameters, String.valueOf(defaultValue)));
    }

    protected String getParam(String paramName, Map<String, String> parameters) {
        return this.getParam(paramName, parameters, null);
    }

    protected String getParam(String paramName, Map<String, String> parameters, Object defaultValue) {
        String defaultVal = defaultValue == null ? null : defaultValue.toString();
        return StringUtils.isBlank((String)parameters.get(paramName)) ? defaultVal : parameters.get(paramName);
    }

    protected boolean hasParam(String paramName, Map<String, String> parameters) {
        return StringUtils.isNotBlank((String)parameters.get(paramName));
    }

    protected String getErrorMessage(ConversionContext context, String errorMessageKey, String ... args) {
        return this.getErrorMessage(context, this.getText(errorMessageKey, args));
    }

    private String getErrorMessage(ConversionContext context, String errorMessage) {
        return this.resolveTemplate(REST_FORUM_ERROR_TEMPLATE).withContext(VelocityContextBuilder.contextBuilder().put(PARAM_ERROR_TITLE, this.getText("com.adaptavist.confluence.restforum.macro.error.title", this.getMacroName(context))).put(PARAM_ERROR_MESSAGE, errorMessage));
    }

    protected String getMacroName(ConversionContext context) {
        Object macroName = context.getProperty(MACRO_NAME);
        return macroName != null ? (String)macroName : "";
    }

    protected boolean hasViewPermissions(ConfluenceUser user, Page page) {
        return this.getPermissionManager().hasPermission((User)user, Permission.VIEW, (Object)page);
    }

    protected String getCurrentUsername() {
        return AuthenticatedUserThreadLocal.getUsername();
    }

    protected ConfluenceUser getCurrentUser() {
        return AuthenticatedUserThreadLocal.get();
    }
}

