/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.validation.impl;

import com.adaptavist.confluence.forums.service.validation.ValidationReport;
import com.adaptavist.confluence.forums.service.validation.Validator;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractSpaceKeyValidator
implements Validator<String> {
    private static final Set<String> EMPTY_VALUES = Sets.newHashSet((Object[])new String[]{"", null});
    private final SpaceManager spaceManager;

    public AbstractSpaceKeyValidator(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    @Override
    public ValidationReport validate(String spaceKey) {
        if (StringUtils.isBlank((String)spaceKey)) {
            return ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.resource.invalid.search.criteria", new Serializable[]{"spaceKey"});
        }
        HashSet spaceKeys = Sets.newHashSet((Object[])spaceKey.trim().split("\\s*[,;]\\s*"));
        Sets.SetView filteredSpaceKeys = Sets.difference((Set)spaceKeys, EMPTY_VALUES);
        return this.validateSpaceKeys((Set<String>)filteredSpaceKeys);
    }

    protected abstract ValidationReport validateSpaceKeys(Set<String> var1);

    protected Space getSpace(String spaceKey) {
        return this.spaceManager.getSpace(spaceKey);
    }
}

