/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.search.sort.comparator;

import com.atlassian.confluence.pages.NaturalStringComparator;
import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.util.BytesRef;

public class TitleFieldComparator
extends FieldComparator<BytesRef> {
    private final Comparator<String> comparator;
    private final String field;
    private final BytesRef tempBR = new BytesRef();
    private BytesRef[] values;
    private BinaryDocValues docTerms;
    private BytesRef bottom;

    public TitleFieldComparator(int numHits, String field) {
        this.comparator = new NaturalStringComparator();
        this.values = new BytesRef[numHits];
        this.field = field;
    }

    public int compare(int slot1, int slot2) {
        BytesRef val1 = this.values[slot1];
        BytesRef val2 = this.values[slot2];
        if (val1 == null) {
            if (val2 == null) {
                return 0;
            }
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        return this.naturalStringComparison(val1, val2);
    }

    public int compareBottom(int doc) {
        this.docTerms.get(doc, this.tempBR);
        if (this.bottom.bytes == BinaryDocValues.MISSING) {
            if (this.tempBR.bytes == BinaryDocValues.MISSING) {
                return 0;
            }
            return -1;
        }
        if (this.tempBR.bytes == BinaryDocValues.MISSING) {
            return 1;
        }
        return this.naturalStringComparison(this.bottom, this.tempBR);
    }

    public void copy(int slot, int doc) {
        if (this.values[slot] == null) {
            this.values[slot] = new BytesRef();
        }
        this.docTerms.get(doc, this.values[slot]);
    }

    public FieldComparator<BytesRef> setNextReader(AtomicReaderContext context) throws IOException {
        this.docTerms = FieldCache.DEFAULT.getTerms(context.reader(), this.field);
        return this;
    }

    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    public BytesRef value(int slot) {
        return this.values[slot];
    }

    public int compareValues(BytesRef val1, BytesRef val2) {
        if (val1 == null) {
            if (val2 == null) {
                return 0;
            }
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        return this.naturalStringComparison(val1, val2);
    }

    public int compareDocToValue(int doc, BytesRef value) {
        this.docTerms.get(doc, this.tempBR);
        return this.naturalStringComparison(this.tempBR, value);
    }

    private int naturalStringComparison(BytesRef bytesRef1, BytesRef bytesRef2) {
        String val1 = this.bytesRefToString(bytesRef1);
        String val2 = this.bytesRefToString(bytesRef2);
        return this.comparator.compare(val1, val2);
    }

    private String bytesRefToString(BytesRef bytesRef) {
        if (bytesRef.length > 0) {
            return bytesRef.utf8ToString();
        }
        return "";
    }
}

