/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.search.criteria.impl;

import com.adaptavist.confluence.forums.service.search.criteria.SearchCriteriaConversionManager;
import com.adaptavist.confluence.forums.service.search.criteria.SearchCriteriaConverter;
import com.adaptavist.confluence.forums.view.beans.search.SearchCriteria;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultSearchCriteriaConversionManager
implements SearchCriteriaConversionManager {
    private final Map<Class<?>, SearchCriteriaConverter> converters;

    @Autowired
    public DefaultSearchCriteriaConversionManager(List<SearchCriteriaConverter> searchCriteriaConverters) {
        this.converters = this.getConverters(searchCriteriaConverters);
    }

    @Override
    public <T extends SearchCriteria> SearchCriteriaConverter<T> getConverter(T searchCriteria) {
        return this.getConverterFor(searchCriteria);
    }

    @Override
    public <T extends SearchCriteria> SearchCriteriaConverter<T> getConverter(Class<T> searchCriteriaType) {
        return this.getConverterFor(searchCriteriaType);
    }

    @Override
    public <T extends SearchCriteria> boolean hasConverter(T searchCriteria) {
        return searchCriteria != null && this.converters.containsKey(searchCriteria.getClass());
    }

    @Override
    public <T extends SearchCriteria> boolean hasConverter(Class<T> searchCriteriaType) {
        return this.converters.containsKey(searchCriteriaType);
    }

    private <T extends SearchCriteria> SearchCriteriaConverter<T> getConverterFor(T criteria) {
        return criteria != null && this.hasConverter(criteria.getClass()) ? this.converters.get(criteria.getClass()) : null;
    }

    private <T extends SearchCriteria> SearchCriteriaConverter<T> getConverterFor(Class<T> criteriaType) {
        return this.hasConverter(criteriaType) ? this.converters.get(criteriaType) : null;
    }

    private Map<Class<?>, SearchCriteriaConverter> getConverters(List<SearchCriteriaConverter> criteriaConverters) {
        HashMap map = new HashMap(criteriaConverters.size());
        for (SearchCriteriaConverter converter : criteriaConverters) {
            map.put(converter.searchCriteriaType(), converter);
        }
        return map;
    }
}

