/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.model.datatypes.impl;

import com.adaptavist.confluence.forums.model.datatypes.DataItemType;
import com.adaptavist.confluence.forums.model.datatypes.DataTypeFormatter;
import com.adaptavist.confluence.forums.model.datatypes.DataTypeManager;
import com.adaptavist.confluence.forums.model.module.impl.DataItemTypeModuleDescriptor;
import com.adaptavist.confluence.forums.view.beans.search.topics.FilterValueType;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.plugin.PluginAccessor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class DefaultDataTypeManager
implements DataTypeManager {
    private final PluginAccessor pluginAccessor;
    private ConcurrentMap<String, DataItemType> dataItemTypes;
    private ConcurrentMap<String, DataTypeFormatter> dataTypeFormatters;

    public DefaultDataTypeManager(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public void flushCaches() {
        this.dataItemTypes = null;
        this.dataTypeFormatters = null;
    }

    private void loadTypes() {
        if (this.dataItemTypes == null) {
            this.dataItemTypes = new ConcurrentHashMap<String, DataItemType>();
            this.dataTypeFormatters = new ConcurrentHashMap<String, DataTypeFormatter>();
            List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(DataItemTypeModuleDescriptor.class);
            for (DataItemTypeModuleDescriptor moduleDescriptor : moduleDescriptors) {
                DataItemType type = moduleDescriptor.getModule().getItem();
                this.putIfAbsent(type.getName(), type, this.dataItemTypes);
                DataTypeFormatter formatter = moduleDescriptor.getModule().getFormatter();
                this.putIfAbsent(formatter.getFormatterName(), formatter, this.dataTypeFormatters);
            }
        }
    }

    @Override
    public DataItemType getDataItemType(String dataItemName) {
        this.loadTypes();
        return this.get(dataItemName, this.dataItemTypes);
    }

    @Override
    public Set<DataItemType> getDataItemTypes(Set<String> dataItemNames) {
        this.loadTypes();
        HashSet<DataItemType> types = new HashSet<DataItemType>();
        if (CollectionUtils.isNotEmpty(dataItemNames)) {
            for (String dataItemTypeName : dataItemNames) {
                if (!this.hasDataItemType(dataItemTypeName)) continue;
                types.add(this.get(dataItemTypeName, this.dataItemTypes));
            }
        }
        return types;
    }

    @Override
    public Collection<DataItemType> getDataItemTypes() {
        this.loadTypes();
        return this.dataItemTypes.values();
    }

    @Override
    public boolean hasDataItemType(String dataItemTypeName) {
        this.loadTypes();
        return this.hasKey(dataItemTypeName, this.dataItemTypes);
    }

    @Override
    public boolean hasDataItemTypes(Set<String> dataItemTypeNames) {
        this.loadTypes();
        for (String dataItemName : dataItemTypeNames) {
            if (this.hasDataItemType(dataItemName)) continue;
            return false;
        }
        return true;
    }

    @Override
    public DataTypeFormatter getDataTypeFormatter(String formatterName) {
        this.loadTypes();
        return this.get(formatterName, this.dataTypeFormatters);
    }

    @Override
    public SearchQuery getSearchQuery(String dataItemName, List<String> filterValues, FilterValueType valueType) {
        this.loadTypes();
        DataItemType dataItemType = this.get(dataItemName, this.dataItemTypes);
        return dataItemType == null ? null : dataItemType.getSearchQuery(filterValues, valueType);
    }

    private <K, V> V get(K key, ConcurrentMap<K, V> concurrentMap) {
        return this.hasKey(key, concurrentMap) ? (V)concurrentMap.get(key) : null;
    }

    private <K, V> boolean hasKey(K key, ConcurrentMap<K, V> concurrentMap) {
        return key != null && concurrentMap.containsKey(key);
    }

    private <K, V> boolean putIfAbsent(K key, V value, ConcurrentMap<K, V> concurrentMap) {
        return key != null && value != null && concurrentMap.putIfAbsent(key, value) == null;
    }
}

