/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums;

import com.adaptavist.confluence.forums.dao.ao.entity.ActivityScoreConfig;
import com.adaptavist.confluence.forums.dao.ao.entity.PermissionsConfig;
import com.adaptavist.confluence.forums.view.beans.search.topics.Filter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public interface ForumConstants {

    public static interface ForumAnalyticsEventType {
        public static final String FORUM_VIEWED = "Forum-Viewed";
        public static final String FORUM_CREATE = "Create-Forum";
        public static final String TOPIC_ADDED = "Topic-Added";
    }

    public static interface ForumAnalyticsEventsName {
        public static final String FORUM_ACTION = "Forum-Action";
        public static final String TOPIC_ACTION = "Topic-Action";
        public static final String APP_CHANGED = "App-Change";
    }

    public static interface ForumHeaderDefaults {
        public static final String FORUM_HEADER_ON = "com.adaptavist.confluence.forums:forum-header-on";
        public static final String FORUM_HEADER_SIZE = "com.adaptavist.confluence.forums:forum-header-size";
        public static final String FORUM_SUMMARY_NOTIFICATION = "com.adaptavist.confluence.forums:forum-summary-notification";
    }

    public static interface ForumConfigDefaults {
        public static final PermissionsConfig.PermissionType STICKY_PERMISSION = PermissionsConfig.PermissionType.PAGE_EDIT;
        public static final boolean STICKY_SPACE_OVERRIDE = false;
        public static final PermissionsConfig.PermissionType LOCKING_PERMISSION = PermissionsConfig.PermissionType.SPACE_ADMIN;
        public static final boolean LOCKING_SPACE_OVERRIDE = false;
        public static final int EDIT_MULTIPLIER = 5;
        public static final int COMMENT_MULTIPLIER = 2;
        public static final int ATTACHMENT_MULTIPLIER = 0;
        public static final ActivityScoreConfig.ContentAge CONTENT_AGE = ActivityScoreConfig.ContentAge.MEDIUM;
    }

    public static interface SearchFilterSortOption {
        public static final String LABEL = "label";
        public static final String KEY = "key";
        public static final String ORDER = "order";
        public static final String OPTION = "option";
        public static final String VALUE = "value";
        public static final String VALUE_TYPE = "value.type";
        public static final String VALUE_TYPE_DATE = "DATE";
        public static final String TOOLTIP = "tooltip";
        public static final String SEARCH_PREFIX = "com.adaptavist.confluence.restforum.search";
        public static final String SEARCH_KEYS_PREFIX = "com.adaptavist.confluence.restforum.search.searchKeys";
        public static final String SORT_SORT_BY_PREFIX = "com.adaptavist.confluence.restforum.sort.sortBy";
        public static final String SORT_STICKY_ON_TOP_PREFIX = "com.adaptavist.confluence.restforum.sort.stickyOnTop";
        public static final String SORT_OPTION_PREFIX = "com.adaptavist.confluence.restforum.sort.option";
        public static final String FILTER_PREFIX = "com.adaptavist.confluence.restforum.filter";
        public static final String DISPLAY_PREFIX_PREFS_PAGE_SIZE = "com.adaptavist.confluence.restforum.display.prefs.pageSize";
    }

    public static interface SearchCriteriaNames {
        public static final String NO_SEARCH_CRITERIA = "null search criteria";
        public static final String ROOT_PAGE_ID = "rootPageId";
        public static final String SPACE_KEY = "spaceKey";
        public static final String SEARCH_KEYS_TEXT = "searchKeys/searchText";
        public static final String SORT_KEY = "sortKey";
        public static final String FILTER = "filter";
        public static final String FILTER_KEY = "filter key";
        public static final String FILTER_VALUES = "filter values";
        public static final String FILTER_VALUE_TYPE = "filter valueType";
        public static final String DATA_ITEM_NAMES = "dataItemNames";
    }

    public static interface SearchDefaults {
        public static final int PAGE_SIZE = 20;
        public static final int START_INDEX = 0;
        public static final String SORT_KEY = "lastactivitydate";
        public static final Set<Filter> FILTERS = Collections.emptySet();
        public static final Set<String> DATA_ITEMS = new HashSet<String>(Arrays.asList("title", "createdby", "creationdate", "status", "lastactivitydate", "replies", "views", "activityscore", "lastcommentby"));
    }

    public static interface MessageKey {
        public static final String RESP_PAGE_NOT_FOUND = "com.adaptavist.confluence.restforum.resource.page.not.found";
        public static final String RESP_PAGE_OR_SPACE_REQUIRED = "com.adaptavist.confluence.restforum.resource.space.or.page.required";
        public static final String RESP_INVALID_SPACE_KEY = "com.adaptavist.confluence.restforum.resource.invalid.space.key";
        public static final String RESP_INVALID_SEARCH_CRITERIA = "com.adaptavist.confluence.restforum.resource.invalid.search.criteria";
        public static final String RESP_INVALID_SEARCH_QUERY = "com.adaptavist.confluence.restforum.resource.invalid.search.query";
        public static final String RESP_GENERIC_SEARCH = "com.adaptavist.confluence.restforum.resource.generic.search";
        public static final String RESP_INVALID_FORMATTER = "com.adaptavist.confluence.restforum.columnmacro.invalid.formatter";
        public static final String RESP_PAGE_REQUIRED = "com.adaptavist.confluence.restforum.macro.page.required";
        public static final String RESP_SPACE_REQUIRED = "com.adaptavist.confluence.restforum.macro.space.required";
        public static final String RESP_NO_SUCH_PAGE = "com.adaptavist.confluence.restforum.macro.no.such.page";
        public static final String RESP_ERROR_TITLE = "com.adaptavist.confluence.restforum.macro.error.title";
        public static final String RESP_NO_PERMISSION = "com.adaptavist.confluence.restforum.macro.no.permission";
        public static final String RESP_PAGE_NOT_SPECIFIED = "com.adaptavist.confluence.restforum.action.sticky.page.not.specified";
        public static final String RESP_STICKY_PERMISSION = "com.adaptavist.confluence.restforum.action.sticky.no.permission";
        public static final String RESP_LOCKING_PERMISSION = "com.adaptavist.confluence.restforum.action.locking.no.permission";
        public static final String RESP_VIEW_STATUS_PERMISSION = "com.adaptavist.confluence.restforum.resource.pages.view.status.permissions";
        public static final String RESP_PAGE_NOT_TOPIC = "com.adaptavist.confluence.restforum.resource.pages.not.topic";
        public static final String RESP_NOT_FORUM_PAGE = "com.adaptavist.confluence.restforum.resource.pages.not.forum.page";
        public static final String RESP_SPACE_NOT_SPECIFIED = "com.adaptavist.confluence.restforum.space.available.forums.space.required";
        public static final String RESP_SPACE_NO_VIEW_PERMISSION = "com.adaptavist.confluence.restforum.space.available.forums.space.no.permission";
        public static final String HEADING_TITLE = "com.adaptavist.confluence.restforum.datatype.title";
        public static final String HEADING_CREATION_DATE = "com.adaptavist.confluence.restforum.datatype.creation.date";
        public static final String HEADING_LAST_ACTIVITY_DATE = "com.adaptavist.confluence.restforum.datatype.last.activity.date";
        public static final String HEADING_LAST_COMMENT_BY = "com.adaptavist.confluence.restforum.datatype.lastcommentby";
        public static final String HEADING_CREATED_BY = "com.adaptavist.confluence.restforum.datatype.created.by";
        public static final String HEADING_STATUS = "com.adaptavist.confluence.restforum.datatype.status";
        public static final String HEADING_NUMBER_OF_REPLIES = "com.adaptavist.confluence.restforum.datatype.number.of.replies";
        public static final String HEADING_NUMBER_OF_VIEWS = "com.adaptavist.confluence.restforum.datatype.number.of.views";
        public static final String HEADING_ACTIVITY_SCORE = "com.adaptavist.confluence.restforum.datatype.activity.score";
        public static final String FORUM_SUMMARY_TABLE_HEADING = "com.adaptavist.confluence.restforumsummary.first.column.default.header";
        public static final String TOPIC_SUMMARY_TABLE_HEADING = "com.adaptavist.confluence.resttopicsummary.first.column.default.header";
        public static final String LABEL_NEW_TOPIC = "com.adaptavist.confluence.restforum.macro.new.topic.label";
    }

    public static interface DataItemFormatterName {
        public static final String FORMATTER_TITLE = "title-formatter";
        public static final String FORMATTER_CREATION_DATE = "creationdate-formatter";
        public static final String FORMATTER_LAST_ACTIVITY_DATE = "lastactivitydate-formatter";
        public static final String FORMATTER_CREATED_BY = "createdby-formatter";
        public static final String FORMATTER_STATUS = "status-formatter";
        public static final String FORMATTER_NUMBER_OF_REPLIES = "replies-formatter";
        public static final String FORMATTER_NUMBER_OF_VIEWS = "views-formatter";
        public static final String FORMATTER_ACTIVITY_SCORE = "activityscore-formatter";
        public static final String FORMATTER_LAST_COMMENT_BY = "lastcommentby-formatter";
    }

    public static interface DataItemValueKey {
        public static final String VALUE_EXCERPT = "topicExcerpt";
        public static final String VALUE_STICKY = "stickyTopic";
        public static final String VALUE_SCORE = "topicScore";
        public static final String VALUE_LOCKED = "lockedTopic";
        public static final String USER_NAME = "username";
        public static final String USER_FULLNAME = "fullname";
        public static final String USER_PICTURE = "picture";
        public static final String USER_KEY = "key";
    }

    public static interface DataItemName {
        public static final String ITEM_TITLE = "title";
        public static final String ITEM_CREATION_DATE = "creationdate";
        public static final String ITEM_LAST_ACTIVITY_DATE = "lastactivitydate";
        public static final String ITEM_CREATED_BY = "createdby";
        public static final String ITEM_STATUS = "status";
        public static final String ITEM_NUMBER_OF_REPLIES = "replies";
        public static final String ITEM_NUMBER_OF_VIEWS = "views";
        public static final String ITEM_ACTIVITY_SCORE = "activityscore";
        public static final String ITEM_LAST_COMMENT_BY = "lastcommentby";
    }

    public static interface SearchQueryTemplate {
        public static final String RANGE_QUERY = "[%s TO %s]";
    }

    public static interface RegExValue {
        public static final String COLON_SEPARATOR = "\\s*[:]\\s*";
        public static final String DEFAULT_SEPARATOR = "\\s*[,;]\\s*";
        public static final String WHITE_SPACE_SEPARATOR = "\\s+";
    }

    public static interface Value {
        public static final Integer FIFTY = 50;
        public static final String TEN = "10";
        public static final String ONE = "1";
        public static final String TRUE = "true";
        public static final String ZERO = "0";
        public static final String EMPTY = "";
        public static final String DOT = ".";
        public static final String COLON = ":";
        public static final String AND = "AND";
        public static final String STAR = "*";
        public static final String QUESTION_MARK = "?";
        public static final String EXCLAMATION_MARK = "!";
        public static final long ONE_DAY = 86400000L;
    }

    public static interface SearchSortKey {
        public static final String SORT_ACTIVITY_SCORE = "forum-sort-activityscore";
        public static final String SORT_CREATED_BY = "forum-sort-createdby";
        public static final String SORT_CREATION_DATE = "forum-sort-creationdate";
        public static final String SORT_LAST_ACTIVITY_DATE = "forum-sort-lastactivitydate";
        public static final String SORT_NUMBER_OF_REPLIES = "forum-sort-replies";
        public static final String SORT_NUMBER_OF_VIEWS = "forum-sort-views";
        public static final String SORT_LAST_COMMENT_BY = "forum-sort-lastcommentby";
        public static final String SORT_TITLE = "forum-sort-title";
        public static final String SORT_STATUS = "forum-sort-status";
    }

    public static interface IndexField {
        public static final String PAGE_ID = "forumIndexPageId";
        public static final String PAGE_TITLE = "forumIndexPageTitle";
        public static final String PAGE_TITLE_NON_ANALYZED = "forumIndexPageTitleNonAnalyzed";
        public static final String PAGE_EXCERPT = "excerpt";
        public static final String PAGE_EXCERPT_MACRO = "forumTopicExcerptMacroContent";
        public static final String PAGE_AUTHOR_FULL_NAME = "forumIndexPageAuthorFullName";
        public static final String PAGE_AUTHOR_USERNAME = "forumIndexPageAuthorUsername";
        public static final String PAGE_STICKY_FLAG = "forumIndexPageIsSticky";
        public static final String PAGE_TOPIC_FLAG_INT = "forumIndexPageIsTopicInt";
        public static final String PAGE_FORUM_FLAG_INT = "forumIndexPageIsForumInt";
        public static final String PAGE_CREATION_DATE = "forumIndexPageCreationDate";
        public static final String PAGE_LAST_ACTIVITY_DATE = "forumIndexPageLastActivityDate";
        public static final String PAGE_LAST_ACTIVITY_AUTHOR = "forumIndexLastActivityAuthor";
        public static final String PAGE_PARTICIPANTS = "forumIndexPageParticipants";
        public static final String PAGE_ACTIVITY_SCORE = "forumIndexPageActivityScore";
        public static final String PAGE_ACTIVITY_SCORE_EXPIRY = "forumIndexPageActivityScoreExpiry";
        public static final String PAGE_NUMBER_OF_REPLIES = "forumIndexPageNumberOfReplies";
        public static final String PAGE_NUMBER_OF_VIEWS = "forumIndexPageNumberOfViews";
        public static final String PAGE_PARENT_ID = "forumIndexPageParentId";
        public static final String PAGE_TOPIC_FORUM_ID = "forumIndexTopicForumId";
        public static final String PAGE_TOPIC_FORUM_TITLE = "forumIndexTopicForumTitle";
        public static final String PAGE_ANCESTORS_IDS = "forumIndexPageAncestorIds";
        public static final String PAGE_LOCKED_FLAG = "forumIndexPageIsLocked";
        public static final String PAGE_LOCKED_FLAG_INT = "forumIndexPageIsLockedInt";
        public static final String TOPIC_COMMENT = "topicComment";
        public static final String TOPIC_LAST_COMMENT_BY = "topicLastCommentBy";
        public static final String TOPIC_LAST_COMMENT_BY_FULLNAME = "topicLastCommentByFullName";
        public static final String TOPIC_LAST_COMMENT_BY_NAME = "topicLastCommentByName";
        public static final String TOPIC_LAST_COMMENT_BY_PICTURE = "topicLastCommentByPicture";
        public static final String TOPIC_LAST_COMMENT_BY_KEY = "topicLastCommentByKey";
    }

    public static interface ForumFlagKey {
        public static final String FORUM_ROOT_PAGE = "com.adaptavist.forum.FORUM_ROOT_PAGE";
        public static final String FORUM_ROOT_PAGE_REFERENCES = "com.adaptavist.forum.FORUM_ROOT_PAGE_REFERENCES";
        public static final String FORUM_TOPIC_PAGE = "com.adaptavist.forum.FORUM_TOPIC_PAGE";
        public static final String FORUM_PAGE_LOCKED = "com.adaptavist.confluence.forum.FORUM_PAGE_LOCKED";
        public static final String FORUM_PAGE_STICKY_FLAG = "com.adaptavist.forum.FORUM_STICKY_PAGE";
        public static final String FORUM_PAGE_LOCKED_FORUM = "com.adaptavist.forum.FORUM_PAGE_LOCKED_FORUM";
    }

    public static interface ForumPluginProps {
        public static final String PLUGIN_KEY = "com.adaptavist.confluence.forums";
    }

    public static enum ForumMacro {
        FORUM("rest-forum"),
        FORUM_SUMMARY("rest-forum-summary"),
        TOPIC_SUMMARY("rest-topic-summary"),
        COLUMN_TITLE("rest-forum-column-title"),
        COLUMN_STATUS("rest-forum-column-status"),
        COLUMN_ACTIVITY_SCORE("rest-forum-column-activityscore"),
        COLUMN_CREATION_DATE("rest-forum-column-creationdate"),
        COLUMN_CREATED_BY("rest-forum-column-createdby"),
        COLUMN_LAST_ACTIVITY_DATE("rest-forum-column-lastactivitydate"),
        COLUMN_REPLIES("rest-forum-column-replies"),
        COLUMN_LAST_COMMENT_BY("rest-forum-column-lastcommentby");

        private final String macroName;

        private ForumMacro(String macroName) {
            this.macroName = macroName;
        }

        public static ForumMacro fromMacroName(String macroName) {
            for (ForumMacro macro : ForumMacro.values()) {
                if (!macro.getMacroName().equals(macroName)) continue;
                return macro;
            }
            return null;
        }

        public String getMacroName() {
            return this.macroName;
        }
    }
}

