/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.view.beans.search.content;

import com.adaptavist.confluence.forums.view.beans.search.Pagination;
import com.adaptavist.confluence.forums.view.beans.search.SearchCriteria;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect
@JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ContentSearchCriteria
extends SearchCriteria
implements Pagination {
    private final SearchScope searchScope;
    private final ContentType contentType;
    private final String rootPageId;
    private final String spaceKey;
    private final int startIndex;
    private final int pageSize;
    private final boolean recursive;
    private final Map<String, String> options;

    @JsonCreator
    public ContentSearchCriteria(@JsonProperty(value="contentType") String contentType, @JsonProperty(value="rootPageId") String rootPageId, @JsonProperty(value="spaceKey") String spaceKey, @JsonProperty(value="startIndex") int startIndex, @JsonProperty(value="pageSize") int pageSize, @JsonProperty(value="recursive") boolean recursive, @JsonProperty(value="options") Map<String, String> options) {
        this.options = this.defaultIfNull(options, Collections.emptyMap());
        this.searchScope = ContentSearchCriteria.getScopeType(rootPageId, spaceKey);
        this.contentType = ContentType.fromString(contentType);
        this.rootPageId = rootPageId;
        this.spaceKey = spaceKey;
        this.startIndex = startIndex;
        this.pageSize = pageSize;
        this.recursive = recursive;
    }

    private static SearchScope getScopeType(String rootPageId, String spaceKey) {
        if (StringUtils.isBlank((String)rootPageId) && StringUtils.isNotBlank((String)spaceKey)) {
            return SearchScope.SPACE;
        }
        return StringUtils.isNotBlank((String)rootPageId) ? SearchScope.PAGE : SearchScope.UNKNOWN;
    }

    @JsonProperty(value="contentType")
    public ContentType getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="rootPageId")
    public String getRootPageId() {
        return this.rootPageId;
    }

    @JsonProperty(value="spaceKey")
    public String getSpaceKey() {
        return this.spaceKey;
    }

    @Override
    @JsonProperty(value="startIndex")
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    @JsonProperty(value="pageSize")
    public int getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="recursive")
    public boolean isRecursive() {
        return this.recursive;
    }

    @JsonProperty(value="options")
    public Map<String, String> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    @JsonIgnore
    public SearchScope getSearchScope() {
        return this.searchScope;
    }

    @JsonIgnore
    public String toString() {
        return "ContentSearchCriteria{detected-searchScope=" + (Object)((Object)this.searchScope) + ", contentType='" + (Object)((Object)this.contentType) + '\'' + ", rootPageId='" + this.rootPageId + '\'' + ", spaceKey='" + this.spaceKey + '\'' + ", startIndex=" + this.startIndex + ", pageSize=" + this.pageSize + ", recursive=" + this.recursive + ", options=" + this.options + '}';
    }

    public static enum ContentType {
        TOPIC,
        FORUM;


        public static ContentType fromString(String searchType) {
            return FORUM.name().equalsIgnoreCase(searchType) ? FORUM : TOPIC;
        }
    }

    public static enum SearchScope {
        PAGE,
        SPACE,
        UNKNOWN;

    }
}

