/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.extractors;

import com.adaptavist.confluence.forums.service.ForumManager;
import com.adaptavist.confluence.forums.service.extractors.AbstractForumExtractor;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.util.ExcerptHelper;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class PageExcerptExtractor
extends AbstractForumExtractor {
    final ExcerptHelper excerptHelper = (ExcerptHelper)ContainerManager.getComponent((String)"excerptHelper", ExcerptHelper.class);
    final ForumManager forumManager;

    public PageExcerptExtractor(ForumManager forumManager) {
        this.forumManager = forumManager;
    }

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        Page page;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (searchable instanceof Page && this.forumManager.isTopic((AbstractPage)(page = (Page)searchable))) {
            builder.add((Object)this.addStringField("forumTopicExcerptMacroContent", this.getPageExcerpt(page)));
        }
        return builder.build();
    }

    private String getPageExcerpt(Page page) {
        String excerpt = this.excerptHelper.getExcerpt((ContentEntityObject)page);
        if (StringUtils.isEmpty((String)excerpt)) {
            excerpt = page.getExcerpt();
        }
        return StringUtils.isEmpty((String)excerpt) ? null : excerpt;
    }
}

