/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.listeners.handler.impl;

import com.adaptavist.confluence.forums.ForumConstants;
import com.adaptavist.confluence.forums.controller.listeners.handler.impl.PageEventAbstractStrategy;
import com.adaptavist.confluence.forums.controller.listeners.handler.impl.util.ForumFlagCreator;
import com.adaptavist.confluence.forums.controller.listeners.handler.impl.util.ForumPagesExtractor;
import com.adaptavist.confluence.forums.service.ForumManager;
import com.adaptavist.confluence.forums.service.PageStatusManager;
import com.adaptavist.confluence.forums.view.macros.params.ParamsParser;
import com.adaptavist.confluence.forums.view.macros.parser.MacroDefinitionParser;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CreatePageEventStrategy
extends PageEventAbstractStrategy<PageCreateEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(CreatePageEventStrategy.class);
    private final MacroDefinitionParser macroDefinitionParser;
    private final ForumManager forumManager;
    private final ForumPagesExtractor forumPagesExtractor;
    private final ForumFlagCreator forumFlagCreator;

    public CreatePageEventStrategy(MacroDefinitionParser macroDefinitionParser, ParamsParser paramsParser, ForumManager forumManager, PageStatusManager pageStatusManager) {
        this.macroDefinitionParser = macroDefinitionParser;
        this.forumManager = forumManager;
        this.forumPagesExtractor = new ForumPagesExtractor(paramsParser);
        this.forumFlagCreator = new ForumFlagCreator(forumManager, pageStatusManager);
    }

    @Override
    public void processPageEvent(PageCreateEvent pageEvent) {
        Page createdPage = this.getPage((PageEvent)pageEvent);
        List<MacroDefinition> macroDefinitions = this.macroDefinitionParser.parseMacroDefinitions(createdPage, ForumConstants.ForumMacro.FORUM);
        this.forumFlagCreator.createForumFlags(createdPage, this.forumPagesExtractor.getForumRootPages(createdPage, macroDefinitions));
        if (this.forumManager.isNewPageEligableAsTopic((AbstractPage)createdPage)) {
            this.forumManager.markAsTopic(Collections.singletonList(createdPage));
            LOG.info("Forum topic flags added after page " + createdPage.getId() + " has been created");
        } else if (this.forumManager.isParentForumLocked(createdPage)) {
            this.forumManager.markAsPageInLockedForum(createdPage);
            LOG.info("Forum locked topic flags added after page " + createdPage.getId() + " has been created");
        }
    }
}

