/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.action.config;

import com.adaptavist.confluence.forums.controller.action.AbstractLicensedAdminAction;
import com.adaptavist.confluence.forums.dao.ao.builder.ActivityScoreConfigBuilder;
import com.adaptavist.confluence.forums.dao.ao.builder.PermissionsConfigBuilder;
import com.adaptavist.confluence.forums.dao.ao.entity.ActivityScoreConfig;
import com.adaptavist.confluence.forums.dao.ao.entity.PermissionsConfig;
import com.adaptavist.confluence.forums.dao.repository.ActivityScoreConfigRepository;
import com.adaptavist.confluence.forums.dao.repository.PermissionsConfigRepository;
import com.adaptavist.confluence.forums.service.ForumManager;
import com.atlassian.xwork.RequireSecurityToken;
import org.apache.commons.lang.StringUtils;

public class GlobalConfigurationAction
extends AbstractLicensedAdminAction {
    private boolean stickySpaceOverride;
    private boolean lockingSpaceOverride;
    private boolean forumHeaderOn;
    private boolean forumSummaryNotification;
    private int forumHeaderSize;
    private PermissionsConfigBuilder permissionsBuilder;
    private ActivityScoreConfigBuilder activityScoreBuilder;
    private PermissionsConfigRepository permissionsService;
    private ActivityScoreConfigRepository activityScoreService;
    private ForumManager forumManager;

    public String getGlobalConfiguration() {
        if (this.isLicensed()) {
            this.loadConfiguration();
            return "success";
        }
        return "pluginlicenseexpired";
    }

    @RequireSecurityToken(value=true)
    public String updateGlobalPermissions() {
        this.permissionsBuilder.withStickySpaceOverride(this.stickySpaceOverride);
        this.permissionsBuilder.withLockingSpaceOverride(this.lockingSpaceOverride);
        PermissionsConfig savedConfig = this.permissionsService.saveGlobalPermissions(this.permissionsBuilder);
        this.permissionsBuilder = PermissionsConfigBuilder.globalPermissionsBuilderFrom(savedConfig);
        this.stickySpaceOverride = this.permissionsBuilder.isStickySpaceOverride();
        this.lockingSpaceOverride = this.permissionsBuilder.isLockingSpaceOverride();
        return "success";
    }

    @RequireSecurityToken(value=true)
    public String updateGlobalActivityScoreConfig() {
        ActivityScoreConfig savedConfig = this.activityScoreService.saveGlobalActivityScoreConfig(this.activityScoreBuilder);
        this.activityScoreBuilder = ActivityScoreConfigBuilder.globalActivityScoreBuilderFrom(savedConfig);
        return "success";
    }

    @RequireSecurityToken(value=true)
    public String updateHeaderConfiguration() {
        this.forumManager.updateHeaderConfiguration(this.forumHeaderOn, this.forumSummaryNotification, this.forumHeaderSize);
        return "success";
    }

    public boolean getForumHeaderOn() {
        return this.forumManager.getForumHeaderOn();
    }

    public void setForumHeaderOn(boolean forumHeaderOn) {
        this.forumHeaderOn = forumHeaderOn;
    }

    public boolean getForumSummaryNotification() {
        return this.forumManager.getForumSummaryNotification();
    }

    public void setForumSummaryNotification(boolean forumSummaryNotification) {
        this.forumSummaryNotification = forumSummaryNotification;
    }

    public int getForumHeaderSize() {
        return this.forumManager.getForumHeaderSize();
    }

    public void setForumHeaderSize(int forumHeaderSize) {
        this.forumHeaderSize = forumHeaderSize;
    }

    public String getStickyPermission() {
        return this.getPermissionsBuilder().getStickyPermission().name();
    }

    public void setStickyPermission(String stickyPermission) {
        PermissionsConfig.PermissionType permission = PermissionsConfig.PermissionType.fromString(stickyPermission);
        if (permission != null) {
            this.getPermissionsBuilder().withStickyPermission(permission);
        }
    }

    public String getLockingPermission() {
        return this.getPermissionsBuilder().getLockingPermission().name();
    }

    public void setLockingPermission(String lockingPermission) {
        PermissionsConfig.PermissionType permission = PermissionsConfig.PermissionType.fromString(lockingPermission);
        if (permission != null) {
            this.getPermissionsBuilder().withLockingPermission(permission);
        }
    }

    public boolean isStickySpaceOverride() {
        return this.stickySpaceOverride;
    }

    public void setStickySpaceOverride(boolean stickySpaceOverride) {
        this.stickySpaceOverride = stickySpaceOverride;
    }

    public boolean isLockingSpaceOverride() {
        return this.lockingSpaceOverride;
    }

    public void setLockingSpaceOverride(boolean lockingSpaceOverride) {
        this.lockingSpaceOverride = lockingSpaceOverride;
    }

    public String getEditMultiplier() {
        return String.valueOf(this.getActivityScoreBuilder().getEditMultiplier());
    }

    public void setEditMultiplier(String editMultiplier) {
        Integer multiplier = this.getMultiplier(editMultiplier);
        if (multiplier != null) {
            this.getActivityScoreBuilder().withEditMultiplier(multiplier);
        }
    }

    public String getCommentMultiplier() {
        return String.valueOf(this.getActivityScoreBuilder().getCommentMultiplier());
    }

    public void setCommentMultiplier(String commentMultiplier) {
        Integer multiplier = this.getMultiplier(commentMultiplier);
        if (multiplier != null) {
            this.getActivityScoreBuilder().withCommentMultiplier(multiplier);
        }
    }

    public String getAttachmentMultiplier() {
        return String.valueOf(this.getActivityScoreBuilder().getAttachmentMultiplier());
    }

    public void setAttachmentMultiplier(String attachmentMultiplier) {
        Integer multiplier = this.getMultiplier(attachmentMultiplier);
        if (multiplier != null) {
            this.getActivityScoreBuilder().withAttachmentMultiplier(multiplier);
        }
    }

    public String getContentAge() {
        return this.getActivityScoreBuilder().getContentAge().name();
    }

    public void setContentAge(String contentAge) {
        ActivityScoreConfig.ContentAge multiplier = ActivityScoreConfig.ContentAge.fromString(contentAge);
        if (multiplier != null) {
            this.getActivityScoreBuilder().withContentAge(multiplier);
        }
    }

    private void loadConfiguration() {
        PermissionsConfig permissions = this.permissionsService.getGlobalPermissions();
        ActivityScoreConfig activityScore = this.activityScoreService.getOrCreateGlobalActivityScoreConfig();
        this.permissionsBuilder = PermissionsConfigBuilder.globalPermissionsBuilderFrom(permissions);
        this.stickySpaceOverride = this.permissionsBuilder.isStickySpaceOverride();
        this.lockingSpaceOverride = this.permissionsBuilder.isLockingSpaceOverride();
        this.activityScoreBuilder = ActivityScoreConfigBuilder.globalActivityScoreBuilderFrom(activityScore);
    }

    private PermissionsConfigBuilder getPermissionsBuilder() {
        if (this.permissionsBuilder == null) {
            this.permissionsBuilder = PermissionsConfigBuilder.globalPermissionsBuilderFrom(this.permissionsService.getGlobalPermissions());
        }
        return this.permissionsBuilder;
    }

    private ActivityScoreConfigBuilder getActivityScoreBuilder() {
        if (this.activityScoreBuilder == null) {
            this.activityScoreBuilder = ActivityScoreConfigBuilder.globalActivityScoreBuilderFrom(this.activityScoreService.getOrCreateGlobalActivityScoreConfig());
        }
        return this.activityScoreBuilder;
    }

    private Integer getMultiplier(String multiplier) {
        String trimmed = StringUtils.trim((String)multiplier);
        try {
            return Integer.parseInt(trimmed);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void setForumPermissionsService(PermissionsConfigRepository permissionsConfigService) {
        this.permissionsService = permissionsConfigService;
    }

    public void setForumActivityScoreService(ActivityScoreConfigRepository activityScoreConfigService) {
        this.activityScoreService = activityScoreConfigService;
    }

    public void setForumManager(ForumManager forumManager) {
        this.forumManager = forumManager;
    }
}

