if (typeof Adaptavist == 'undefined') {
    var Adaptavist = {};
}
if (typeof Adaptavist.Forums == 'undefined') {
    Adaptavist.Forums = {};
}
if (typeof Adaptavist.Forums.RestForumSummary == 'undefined') {
    Adaptavist.Forums.RestForumSummary = {};
}

AJS.toInit(function ($) {

    Adaptavist.Forums.RestForumSummary.init = function () {
        var rootElement = getJQElement(this);
        var tableElement = rootElement.find('.restforumsummarytable');
        prefs = {
            $element: rootElement,
            $table: tableElement,
            rootPageId: rootElement.attr('data-target-root-page'),
            spaceKey: rootElement.attr('data-target-space-key'),
            includeSubForums: rootElement.attr('data-recurse'),
            tableHeading: rootElement.attr('data-table-heading'),
            showExcerpt: rootElement.attr('data-show-excerpt'),
            showPics: rootElement.attr('data-show-pics'),
            showAuthor: rootElement.attr('data-show-author'),
            sortBy: rootElement.attr('data-sortby'),
            bgStyle: tableElement.attr('style')
        };
        prefs.searchCriteria = {
            contentType: 'FORUM',
            rootPageId: prefs.rootPageId,
            spaceKey: prefs.spaceKey,
            recursive: prefs.includeSubForums,
            startIndex: 0,
            pageSize: 0,
            options: {sortBy: rootElement.attr('data-sortby')}
        }; //page size 0 means no pagination
        searchForumPages(prefs);
    };

    function searchForumPages(prefs) {
        $.ajax({
            type: 'POST',
            url: contextPath + '/rest/forums/latest/search/content',
            data: JSON.stringify(prefs.searchCriteria),
            contentType: 'application/json; charset=utf-8',
            dataType: 'json'
        }).done(function (forumSearchResults) {
            render(forumSearchResults, prefs);
        }).fail(function (response) {
            var title = AJS.I18n.getText("com.adaptavist.confluence.restforumsummary.resource.error.title");
            error(title, response.responseText, prefs);
        });
    }

    function render(forumSearchResults, prefs) {
        formatData(forumSearchResults);
        var templateData = {
            forums: forumSearchResults.forums,
            contextPath: contextPath,
            tableHeading: prefs.tableHeading,
            showPics: prefs.showPics,
            showExcerpt: prefs.showExcerpt,
            showAuthor: prefs.showAuthor,
            bgStyle: prefs.bgStyle
        };
        prefs.$table.html(Adaptavist.Forums.RestForumSummary.templates.forumsSummary(templateData));
        if (forumSearchResults.total == 0) {
            var title = AJS.I18n.getText("com.adaptavist.confluence.restforumsummary.search.no.forums.found.title");
            var body = AJS.I18n.getText("com.adaptavist.confluence.restforumsummary.search.no.forums.found.body");
            var info = {title: title, body: body};
            $('.restforumMessages', prefs.$element).html(Adaptavist.Forums.RestForumSummary.templates.info({info: info}));
        } else {
            $('.restforumMessages', prefs.$element).html("");
        }

        // Show the user's details when we are on the user link
        Confluence.Binder.userHover();
    }

    function error(title, message, prefs) {
        var error = {title: title, body: message};
        $('.restforumMessages', prefs.$element).html(Adaptavist.Forums.RestForumSummary.templates.error({error: error}));
    }

    function formatData(forumSearchResults) {
        var forums = forumSearchResults.forums;
        forums.forEach(function (forum) {
            forum.formattedCreationDate = formatDate(forum.creationDate);
            forum.formattedLastReplyDate = formatDate(forum.lastReplyDate);
        });
    }

    function formatDate(date) {
        return moment(Number(date)).fromNow();
    }

    function getJQElement(elem) {
        return $(elem);
    }

    function initPdfWarningDialog() {
        AJS.InlineDialog(
            $('#action-export-pdf-link'),
            'pdfLink',
            function (content, trigger, showPopup) {
                content
                    .css(
                        {
                            padding: '20px'
                        })
                    .html(
                        '<h2>Please note</h2>' +
                        '<p>Unfortunately, it\'s not currently possible to export a page containing Forums to a pdf using Confluence\'s built in pdf exporter.</p>' +
                        '<p>To get a pdf file of this page, please use your browsers built in "<a target="_blank" href="https://docs.adaptavist.com/x/hYNWBg">Save as pdf</a>" functionality.</p>' +
                        '<p><a target="_blank" href="https://docs.adaptavist.com/x/hYNWBg">Read more</a></p>'
                    );
                showPopup();
                return false;
            }
        );
    }

    $('.restforumsummary').each(Adaptavist.Forums.RestForumSummary.init);

    initPdfWarningDialog();
});

