/*global jQuery, AJS, Option */

/* genericColumnMacro.js
 *
 * Add customisations to the default Macro Browser to make editing of {forum-generic-column} macro easier.
 *
 */
AJS.toInit(function ($) {

    var data = "com.adaptavist.forums:column.data";

    function dropDown(multiple) {
        var paramDiv = $(Confluence.Templates.MacroBrowser.macroParameterSelect()),
            select = $("select", paramDiv),
            input = $('<input type="hidden"/>').appendTo(paramDiv);

        select
            .attr('multiple', multiple)
            .bind('change', function () {
                if (multiple) {
                    input.val((select.val() || []).join(" ")).change();
                } else {
                    input.val(select.val()).change();
                }
            });

        var options = {
            setValue: function (value) {
                var val = $.trim(value);
                input.val(val);
                select.val(val.split(/\s+/));
            }
        };

        return AJS.MacroBrowser.Field(paramDiv, input, options);
    }

    function removeAllOptions(select) {
        select.options.length = 0;
    }

    function addOption(select, value, label) {
        select.options[select.options.length] = new Option(label, value);
    }

    var columnSelect, formatSelect, headingInput, columnDiv;

    function selectColumn(column) {
        updateFormatSelect(column);
        updateHeadingInput(column);
    }

    function updateFormatSelect(column) {
        if (formatSelect) {
            removeAllOptions(formatSelect);
            if (column && data.columns[column]) {
                $.each(data.columns[column].formatters, function (index, element) {
                    addOption(formatSelect, index, element);
                });
            }
            $(formatSelect).change();
        }
    }

    function updateHeadingInput(column) {
        if (headingInput) {
            $(headingInput).val((column && data.columns[column]) ? data.columns[column].heading : "");
            $(headingInput).change();
        }
    }

    var overrides = {
        "fields": {
            "string": {
                "column": function () {
                    var field = dropDown(false);
                    columnDiv = $("select", field.paramDiv);
                    var select = columnDiv[0];

                    columnSelect = select;
                    $.each(data.columns, function (index, element) {
                        addOption(select, index, element.displayName);
                    });
                    columnDiv.on("change", function (e) {
                        selectColumn($(e.target).val());
                    });
                    return field;
                },
                "format": function () {
                    var field = dropDown(false),
                        select = $("select", field.paramDiv)[0];

                    formatSelect = select;

                    return field;
                },
                "heading": function (param, options) {
                    var field = AJS.MacroBrowser.ParameterFields.string(param, options),
                        input = $("input", field.paramDiv)[0];

                    headingInput = input;

                    return field;
                }
            }
        },
        "beforeParamsSet": function (selectedParams) {
            updateFormatSelect(selectedParams.column);
            columnDiv.change();
            return selectedParams;
        }
    };

    AJS.MacroBrowser.setMacroJsOverride("rest-forum-column-generic", overrides);
});
