/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.view.macros;

import com.adaptavist.confluence.forums.ForumConstants;
import com.adaptavist.confluence.forums.view.macros.AbstractSummaryMacro;
import com.adaptavist.confluence.forums.view.macros.aggregator.MacroServiceAggregator;
import com.adaptavist.confluence.forums.view.macros.velocity.builder.VelocityContextBuilder;
import com.adaptavist.confluence.support.LicensingSupport;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import java.util.Map;

public class RestTopicSummaryMacro
extends AbstractSummaryMacro {
    public static final String PARAM_SHOW_FORUM = "showForum";
    public static final String PARAM_SHOW_STATUS = "showStatus";
    public static final String PARAM_STICKY_ON_TOP = "sortStickyOnTop";
    public static final String PARAM_ACTIVITY_THRESHOLD = "activityIndicatorThreshold";
    public static final String PARAM_PAGE_SIZE = "pageSize";
    private static final String TOPIC_SUMMARY_MACRO_TEMPLATE = "forum/templates/vm/rest-topic-summary.vm";

    public RestTopicSummaryMacro(LicensingSupport licensingSupport, MacroServiceAggregator macroServiceAggregator, XhtmlContent xhtmlContent) {
        super(licensingSupport, macroServiceAggregator, xhtmlContent);
    }

    @Override
    protected String getRenderedTemplateLocation() {
        return TOPIC_SUMMARY_MACRO_TEMPLATE;
    }

    @Override
    protected void addSpecificParams(Map<String, String> parameters, VelocityContextBuilder contextBuilder) {
        String defaultHeading = this.getText("com.adaptavist.confluence.resttopicsummary.first.column.default.header", new String[0]);
        String tableHeading = this.getParam("tableHeading", parameters, defaultHeading);
        int pageSize = this.getIntParam(PARAM_PAGE_SIZE, parameters, 20);
        boolean recurse = this.getBooleanParam("recurse", parameters, true);
        boolean showForum = this.getBooleanParam(PARAM_SHOW_FORUM, parameters, false);
        boolean showAuthor = this.getBooleanParam("showAuthor", parameters, true);
        boolean showStatus = this.getBooleanParam(PARAM_SHOW_STATUS, parameters, true);
        boolean sortStickyOnTop = this.getBooleanParam(PARAM_STICKY_ON_TOP, parameters, true);
        int activityThreshold = this.getIntParam(PARAM_ACTIVITY_THRESHOLD, parameters, ForumConstants.Value.FIFTY);
        contextBuilder.put("recurse", recurse).put(PARAM_PAGE_SIZE, pageSize).put("tableHeading", tableHeading).put("showAuthor", showAuthor).put(PARAM_SHOW_FORUM, showForum).put(PARAM_SHOW_STATUS, showStatus).put(PARAM_STICKY_ON_TOP, sortStickyOnTop).put(PARAM_ACTIVITY_THRESHOLD, activityThreshold);
    }

    @Override
    protected String getDefaultMode() {
        return "space";
    }
}

