/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.servlet.analytic;

import com.adaptavist.confluence.forums.model.AnalyticServiceStateModel;
import com.adaptavist.confluence.forums.service.analytic.ForumsAnalyticService;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.Reader;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticsServlet.class);
    private Gson gson = new Gson();
    private ForumsAnalyticService forumsAnalyticService;

    public AnalyticsServlet(ForumsAnalyticService forumsAnalyticService) {
        this.forumsAnalyticService = forumsAnalyticService;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.getWriter().write(this.gson.toJson((Object)new AnalyticServiceStateModel(this.forumsAnalyticService.isAdaptavistAnalyticsEnabled())));
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean analyticsState = ((AnalyticServiceStateModel)this.gson.fromJson((Reader)request.getReader(), AnalyticServiceStateModel.class)).isAnalyticsStateEnabled();
            if (analyticsState) {
                this.forumsAnalyticService.enable();
            } else {
                this.forumsAnalyticService.disable();
            }
        }
        catch (IOException e) {
            LOG.error("An unrecoverable error occurred whilst trying to update the service status in the user interface", (Throwable)e);
        }
    }
}

