/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.upgradetasks;

import com.adaptavist.confluence.forums.ForumConstants;
import com.adaptavist.confluence.forums.controller.listeners.handler.impl.util.ForumPagesExtractor;
import com.adaptavist.confluence.forums.service.ForumManager;
import com.adaptavist.confluence.forums.service.search.SearchManagerDelegate;
import com.adaptavist.confluence.forums.service.search.query.MacroNameQuery;
import com.adaptavist.confluence.forums.service.search.results.SearchResultAccessors;
import com.adaptavist.confluence.forums.view.macros.params.PageSpaceParam;
import com.adaptavist.confluence.forums.view.macros.params.ParamsParser;
import com.adaptavist.confluence.forums.view.macros.parser.MacroDefinitionParser;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ForumRootPagePropertiesUpgradeTask
implements PluginUpgradeTask {
    private static final int CONFLUENCE_7_20_MINIMUM_BUILD_NUMBER = 18270;
    private static final String PLUGIN_KEY = "com.adaptavist.confluence.forums";
    private static final String REST_FORUMS_MACRO_NAME = "rest-forum";
    private final ApplicationProperties applicationProperties;
    private final ForumManager forumManager;
    private final ForumPagesExtractor forumPagesExtractor;
    private final MacroDefinitionParser macroDefinitionParser;
    private final PageManager pageManager;
    private final SearchManagerDelegate searchManager;

    public ForumRootPagePropertiesUpgradeTask(ApplicationProperties applicationProperties, ForumManager forumManager, MacroDefinitionParser macroDefinitionParser, PageManager pageManager, ParamsParser paramsParser, SearchManagerDelegate searchManager) {
        this.applicationProperties = applicationProperties;
        this.forumManager = forumManager;
        this.macroDefinitionParser = macroDefinitionParser;
        this.pageManager = pageManager;
        this.searchManager = searchManager;
        this.forumPagesExtractor = new ForumPagesExtractor(paramsParser);
    }

    public int getBuildNumber() {
        return 110;
    }

    public String getShortDescription() {
        return "Store the forums index reference as a property in the root pages";
    }

    public Collection<Message> doUpgrade() throws Exception {
        SearchQuery searchQuery = this.getPagesWithForumsMacro();
        SearchResultAccessors resultAccessors = this.searchManager.search(this.isConfluence720OrAbove() < 0 ? this.compatibilityContentSearch(searchQuery) : this.initialiseContentSearch(searchQuery));
        resultAccessors.forEach(resultAccessor -> {
            Page page = this.pageManager.getPage(resultAccessor.getId());
            List<MacroDefinition> macroDefinitions = this.macroDefinitionParser.parseMacroDefinitions(page, ForumConstants.ForumMacro.FORUM);
            Set<PageSpaceParam> rootPages = this.forumPagesExtractor.getForumRootPages(page, macroDefinitions);
            rootPages.forEach(rootPageParams -> this.forumManager.addIndexReference(rootPageParams.getPage(), page));
        });
        return Collections.emptySet();
    }

    public String getPluginKey() {
        return PLUGIN_KEY;
    }

    private SearchQuery getPagesWithForumsMacro() {
        MacroNameQuery topicQuery = new MacroNameQuery(REST_FORUMS_MACRO_NAME);
        ContentTypeQuery pageOrBlog = new ContentTypeQuery(Arrays.asList(ContentTypeEnum.PAGE, ContentTypeEnum.BLOG));
        List<SearchQuery> mustQueries = this.querySet(new SearchQuery[]{topicQuery, pageOrBlog});
        return new BooleanQuery(mustQueries, null, null);
    }

    private List<SearchQuery> querySet(SearchQuery ... searchQueries) {
        ArrayList<SearchQuery> queries = new ArrayList<SearchQuery>(searchQueries.length);
        Collections.addAll(queries, searchQueries);
        return queries;
    }

    private ContentSearch initialiseContentSearch(SearchQuery searchQuery) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class[] contentSearchArgsType = new Class[]{SearchQuery.class, SearchSort.class, Integer.TYPE, Integer.TYPE};
        Constructor contentSearchConstructor = ContentSearch.class.getConstructor(contentSearchArgsType);
        Object[] contentSearchArgs = new Object[]{searchQuery, null, 0, Integer.MAX_VALUE};
        return (ContentSearch)contentSearchConstructor.newInstance(contentSearchArgs);
    }

    private ContentSearch compatibilityContentSearch(SearchQuery searchQuery) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> sfClazz = Class.forName("com.atlassian.confluence.search.v2.SearchFilter");
        Class[] contentSearchArgsType = new Class[]{SearchQuery.class, SearchSort.class, sfClazz, Integer.TYPE, Integer.TYPE};
        Constructor contentSearchConstructor = ContentSearch.class.getConstructor(contentSearchArgsType);
        Object[] contentSearchArgs = new Object[]{searchQuery, null, null, 0, Integer.MAX_VALUE};
        return (ContentSearch)contentSearchConstructor.newInstance(contentSearchArgs);
    }

    private Integer isConfluence720OrAbove() {
        return Integer.compare(Integer.parseInt(this.applicationProperties.getBuildNumber()), 18270);
    }
}

