/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.extractors;

import com.adaptavist.confluence.forums.controller.listeners.ForumsTopicViewsCacheManager;
import com.adaptavist.confluence.forums.service.extractors.AbstractForumExtractor;
import com.adaptavist.confluence.forums.service.impl.PagePropertySupport;
import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.google.common.collect.ImmutableList;
import java.util.Collection;

public class TopicViewsExtractor
extends AbstractForumExtractor {
    final PagePropertySupport pagePropertySupport;
    final ForumsTopicViewsCacheManager forumsTopicViewsCacheManager;
    final AccessModeCompatService accessModeCompatService;

    public TopicViewsExtractor(PagePropertySupport pagePropertySupport, CacheManager cacheManager, AccessModeCompatService accessModeCompatService) {
        this.pagePropertySupport = pagePropertySupport;
        this.forumsTopicViewsCacheManager = new ForumsTopicViewsCacheManager(cacheManager);
        this.accessModeCompatService = accessModeCompatService;
    }

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (searchable instanceof Page) {
            Page page = (Page)searchable;
            builder.add((Object)this.addIntegerField("forumIndexPageNumberOfViews", this.getSavedViews(page) + this.getCachedViews(page)));
        }
        return builder.build();
    }

    private int getSavedViews(Page page) {
        String savedViews = this.pagePropertySupport.getStringProperty((AbstractPage)page, "forumIndexPageNumberOfViews");
        return savedViews == null ? 0 : Integer.parseInt(savedViews);
    }

    private int getCachedViews(Page page) {
        if (!this.accessModeCompatService.isReadOnlyAccessModeEnabled()) {
            return 0;
        }
        return Integer.parseInt(this.forumsTopicViewsCacheManager.getCachedViews((AbstractPage)page));
    }
}

