/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.dao.ao.builder;

import com.adaptavist.confluence.forums.ForumConstants;
import com.adaptavist.confluence.forums.dao.ao.builder.AbstractEntityBuilder;
import com.adaptavist.confluence.forums.dao.ao.entity.ActivityScoreConfig;
import com.adaptavist.confluence.forums.dao.ao.entity.ForumConfigEntity;

public class ActivityScoreConfigBuilder
extends AbstractEntityBuilder {
    private static final ActivityScoreConfigBuilder GLOBAL_DEFAULT = ActivityScoreConfigBuilder.globalActivityScoreBuilder().withEditMultiplier(5).withCommentMultiplier(2).withAttachmentMultiplier(0).withContentAge(ForumConstants.ForumConfigDefaults.CONTENT_AGE);
    private int editMultiplier;
    private int commentMultiplier;
    private int attachmentMultiplier;
    private ActivityScoreConfig.ContentAge contentAge;

    private ActivityScoreConfigBuilder(ForumConfigEntity.Scope scope, String spaceKey) {
        super(scope, spaceKey);
    }

    public static ActivityScoreConfigBuilder defaultGlobalActivityScoreBuilder() {
        return ActivityScoreConfigBuilder.copy(ActivityScoreConfigBuilder.globalActivityScoreBuilder(), GLOBAL_DEFAULT);
    }

    public static ActivityScoreConfigBuilder globalActivityScoreBuilder() {
        return new ActivityScoreConfigBuilder(ForumConfigEntity.Scope.GLOBAL, null);
    }

    public static ActivityScoreConfigBuilder spaceActivityScoreBuilder(String spaceKey) {
        return new ActivityScoreConfigBuilder(ForumConfigEntity.Scope.SPACE, spaceKey);
    }

    public static ActivityScoreConfigBuilder globalActivityScoreBuilderFrom(ActivityScoreConfig config) {
        return config == null ? ActivityScoreConfigBuilder.globalActivityScoreBuilder() : ActivityScoreConfigBuilder.builder(ForumConfigEntity.Scope.GLOBAL, config);
    }

    public static ActivityScoreConfigBuilder spaceActivityScoreBuilderFrom(ActivityScoreConfig config) {
        return config == null ? ActivityScoreConfigBuilder.globalActivityScoreBuilder() : ActivityScoreConfigBuilder.builder(ForumConfigEntity.Scope.SPACE, config);
    }

    private static ActivityScoreConfigBuilder builder(ForumConfigEntity.Scope scope, ActivityScoreConfig config) {
        String spaceKey = ForumConfigEntity.Scope.SPACE.equals((Object)scope) ? config.getSpaceKey() : null;
        return ActivityScoreConfigBuilder.copy(new ActivityScoreConfigBuilder(scope, spaceKey), config);
    }

    private static ActivityScoreConfigBuilder copy(ActivityScoreConfigBuilder to, ActivityScoreConfigBuilder from) {
        return to.withEditMultiplier(from.getEditMultiplier()).withCommentMultiplier(from.getCommentMultiplier()).withAttachmentMultiplier(from.getAttachmentMultiplier()).withContentAge(from.getContentAge());
    }

    private static ActivityScoreConfigBuilder copy(ActivityScoreConfigBuilder to, ActivityScoreConfig from) {
        return to.withEditMultiplier(from.getEditMultiplier()).withCommentMultiplier(from.getCommentMultiplier()).withAttachmentMultiplier(from.getAttachmentMultiplier()).withContentAge(from.getContentAge());
    }

    public int getEditMultiplier() {
        return this.editMultiplier;
    }

    public ActivityScoreConfigBuilder withEditMultiplier(int editMultiplier) {
        this.editMultiplier = editMultiplier;
        return this;
    }

    public int getCommentMultiplier() {
        return this.commentMultiplier;
    }

    public ActivityScoreConfigBuilder withCommentMultiplier(int commentMultiplier) {
        this.commentMultiplier = commentMultiplier;
        return this;
    }

    public int getAttachmentMultiplier() {
        return this.attachmentMultiplier;
    }

    public ActivityScoreConfigBuilder withAttachmentMultiplier(int attachmentMultiplier) {
        this.attachmentMultiplier = attachmentMultiplier;
        return this;
    }

    public ActivityScoreConfig.ContentAge getContentAge() {
        return this.contentAge;
    }

    public ActivityScoreConfigBuilder withContentAge(ActivityScoreConfig.ContentAge contentAge) {
        this.contentAge = contentAge;
        return this;
    }

    public ActivityScoreConfigBuilder toGlobal() {
        return ActivityScoreConfigBuilder.copy(ActivityScoreConfigBuilder.globalActivityScoreBuilder(), this);
    }

    public ActivityScoreConfigBuilder toSpace(String spaceKey) {
        return ActivityScoreConfigBuilder.copy(ActivityScoreConfigBuilder.spaceActivityScoreBuilder(spaceKey), this);
    }
}

