/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.utils.task;

import co.uk.automationconsultants.compliance.json.task.TaskJson;
import co.uk.automationconsultants.compliance.json.task.TaskStatusEnum;
import jakarta.annotation.Nonnull;

public class TaskVerificationUtils {
    private TaskVerificationUtils() {
    }

    public static void verifyTaskUpdate(@Nonnull TaskJson update) throws IllegalArgumentException {
        if (update.getId() <= 0) {
            throw new IllegalArgumentException("No ID was given");
        }
        TaskStatusEnum status = update.getStatus();
        if (TaskVerificationUtils.invalidStatusForField(update.getTimeStarted(), status, TaskStatusEnum.IN_PROGRESS)) {
            throw new IllegalArgumentException("Time Started was passed without valid status");
        }
        if (TaskVerificationUtils.invalidStatusForField(update.getElectedNode(), status, TaskStatusEnum.DELEGATED)) {
            throw new IllegalArgumentException("Elected Node was passed in without delegated status");
        }
        if (status != null && status.equals((Object)TaskStatusEnum.DELEGATED) && update.getElectedNode() == null) {
            throw new IllegalArgumentException("Delegated status was passed without elected node");
        }
        if (!(update.getTimeEnded() == null || status != null && TaskStatusEnum.isFinishedStatus(status))) {
            throw new IllegalArgumentException("Time Ended was passed with invalid status");
        }
        if (update.getTotalCount() > 0 && update.getTotalCount() < update.getFailed() + update.getWarning() + update.getSuccess() + update.getSkipped()) {
            throw new IllegalArgumentException("counts (warning, success, failed, skipped) are greater than totalCount");
        }
    }

    private static boolean invalidStatusForField(Object field, TaskStatusEnum status, TaskStatusEnum expected) {
        return field != null && (status == null || !status.equals((Object)expected));
    }
}

