/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.utils;

import co.uk.automationconsultants.compliance.entity.extractions.ExtractionEntity;
import co.uk.automationconsultants.compliance.json.capture.ExtractionJson;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractionUtils {
    private static final Logger log = LoggerFactory.getLogger(ExtractionUtils.class);

    private ExtractionUtils() {
        throw new IllegalStateException("Utility Class");
    }

    public static ExtractionJson[] getExtractionsFromJson() throws IOException {
        InputStream inputStream = ExtractionUtils.class.getResourceAsStream("/json/systemExtractions.json");
        if (inputStream != null) {
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)StandardCharsets.UTF_8.name());
            return (ExtractionJson[])new Gson().fromJson(writer.toString(), ExtractionJson[].class);
        }
        throw new IOException("Could not get extractions from json");
    }

    public static void createEntities(ActiveObjects activeObjects) {
        try {
            ExtractionJson[] extractions;
            for (ExtractionJson extractionJson : extractions = ExtractionUtils.getExtractionsFromJson()) {
                ExtractionUtils.createEntity(extractionJson.getName(), extractionJson.getDescription(), extractionJson.getIcon(), extractionJson.getRegEx(), activeObjects);
            }
            ExtractionUtils.validateEntitiesForUpdates(activeObjects, extractions);
        }
        catch (IOException e) {
            log.error("Error getting Extractions from json");
            e.printStackTrace();
        }
    }

    public static void validateEntitiesForUpdates(ActiveObjects activeObjects, ExtractionJson[] extractions) {
        for (ExtractionJson extraction : extractions) {
            if (extraction.getInvalidRegexes().length <= 0) continue;
            ExtractionUtils.updateEntityIfMatched(extraction.getName(), new ArrayList<String>(Arrays.asList(extraction.getInvalidRegexes())), extraction.getRegEx(), activeObjects);
        }
    }

    public static void updateEntityIfMatched(String name, List<String> matches, String newValue, ActiveObjects activeObjects) {
        ExtractionEntity[] matchedExtractions = (ExtractionEntity[])activeObjects.find(ExtractionEntity.class, Query.select().where("NAME = ?", new Object[]{name}));
        if (matchedExtractions.length > 0) {
            ExtractionEntity entity = matchedExtractions[0];
            for (String match : matches) {
                if (!entity.getRegEx().equals(match)) continue;
                entity.setRegEx(newValue);
                entity.save();
            }
        }
    }

    public static void createEntity(String name, String description, String icon, String regEx, ActiveObjects activeObjects) {
        activeObjects.executeInTransaction(() -> {
            if (activeObjects.count(ExtractionEntity.class, Query.select().where("NAME = ?", new Object[]{name})) == 0) {
                activeObjects.create(ExtractionEntity.class, new DBParam[]{new DBParam("NAME", (Object)name), new DBParam("DESCRIPTION", (Object)description), new DBParam("ICON", (Object)icon), new DBParam("REG_EX", (Object)regEx), new DBParam("ENABLED", (Object)false), new DBParam("SYS_DEFINED", (Object)true)});
            }
            return true;
        });
    }
}

