/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.task.tasks;

import co.uk.automationconsultants.compliance.cache.SpaceSettingsCache;
import co.uk.automationconsultants.compliance.helper.SpaceHelper;
import co.uk.automationconsultants.compliance.json.task.LogLevelEnum;
import co.uk.automationconsultants.compliance.json.task.params.BulkSpaceParams;
import co.uk.automationconsultants.compliance.service.BulkChangeSpaceService;
import co.uk.automationconsultants.compliance.service.task.TaskDBService;
import co.uk.automationconsultants.compliance.task.TaskRunnable;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.gson.Gson;
import java.util.List;

public class BulkChangeSpaceTask
extends TaskRunnable {
    private final BulkChangeSpaceService bulkChangeSpaceService;
    private final SpaceHelper spaceHelper;
    private final SpaceSettingsCache spaceSettingsCache;

    public BulkChangeSpaceTask(TaskDBService taskDBService, int taskId, String paramsJson, BulkChangeSpaceService bulkChangeSpaceService, TransactionTemplate transactionTemplate, ConfluenceUser user, SpaceHelper spaceHelper, SpaceSettingsCache spaceSettingsCache) {
        super(taskDBService, taskId, paramsJson, user, transactionTemplate);
        this.bulkChangeSpaceService = bulkChangeSpaceService;
        this.spaceHelper = spaceHelper;
        this.spaceSettingsCache = spaceSettingsCache;
    }

    @Override
    public void execute() {
        BulkSpaceParams params = (BulkSpaceParams)new Gson().fromJson(this.getParamsJson(), BulkSpaceParams.class);
        int totalSpaceCount = this.spaceHelper.getSpaceCount();
        this.updateTotalCount(totalSpaceCount);
        int limit = 25;
        int start = Math.max(totalSpaceCount - limit, 0);
        boolean more = true;
        this.spaceSettingsCache.invalidateCache();
        while (more && !this.isCancelled()) {
            PageResponse<Space> pageResponse = this.spaceHelper.getCurrentSpaces(start, limit);
            int successCount = 0;
            List results = pageResponse.getResults();
            for (Space space : results) {
                if (this.isCancelled()) break;
                boolean success = this.processSpace(params, space);
                if (!success) continue;
                ++successCount;
            }
            this.updateProgress(results.size(), successCount, this.isCancelled());
            boolean bl = more = start > 0;
            if (start - limit < 0) {
                limit = start;
                start = 0;
                continue;
            }
            start -= limit;
        }
    }

    private void updateProgress(int batchSize, int successCount, boolean cancelled) {
        this.transactionTemplate.execute(() -> {
            this.taskDBService.incrementSuccessValue(this.taskId, successCount);
            if (!cancelled) {
                this.taskDBService.incrementFailedValue(this.taskId, batchSize - successCount);
            } else {
                this.taskDBService.updateSkipped(this.taskId);
            }
            return null;
        });
    }

    private boolean processSpace(BulkSpaceParams params, Space space) {
        try {
            this.bulkChangeSpaceService.modifySpaceSettings(space.getKey(), params.getEnabled(), params.getType());
            return true;
        }
        catch (Exception e) {
            this.addTaskLog(LogLevelEnum.ERROR, e.getMessage(), null, space.getId(), space.getKey());
            return false;
        }
    }
}

