/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.servlet;

import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;

public class AdminServlet
extends HttpServlet {
    @ComponentImport
    private final WebSudoManager webSudoManager;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final VelocityHelperService velocityHelperService;

    @Inject
    public AdminServlet(WebSudoManager webSudoManager, UserManager userManager, VelocityHelperService velocityHelperService) {
        this.webSudoManager = webSudoManager;
        this.userManager = userManager;
        this.velocityHelperService = velocityHelperService;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (request.getRemoteUser() == null) {
            response.sendError(401);
        } else {
            try {
                if (!this.userManager.isAdmin(this.userManager.getRemoteUserKey(request))) {
                    response.sendError(403);
                }
                this.webSudoManager.willExecuteWebSudoRequest(request);
                response.setContentType("text/html;charset=utf-8");
                HashMap params = new HashMap();
                try {
                    response.getWriter().write(this.velocityHelperService.getRenderedTemplate("/templates/display/admin/compliance-page.vm", params));
                }
                catch (IOException e) {
                    response.sendError(500);
                }
            }
            catch (WebSudoSessionException wes) {
                this.webSudoManager.enforceWebSudoProtection(request, response);
            }
        }
    }
}

