/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service.task;

import co.uk.automationconsultants.compliance.exception.task.NoSuchTaskException;
import co.uk.automationconsultants.compliance.exception.task.TaskCancellationException;
import co.uk.automationconsultants.compliance.exception.task.TaskExecutionException;
import co.uk.automationconsultants.compliance.json.task.TaskJson;
import co.uk.automationconsultants.compliance.json.task.TaskStatusEnum;
import co.uk.automationconsultants.compliance.service.task.TaskDBService;
import co.uk.automationconsultants.compliance.task.TaskExecutor;
import co.uk.automationconsultants.compliance.utils.task.TaskDBServiceUtils;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Random;
import java.util.concurrent.TimeUnit;

@Named(value="taskExecutionService")
public class TaskExecutionService {
    private final TaskExecutor taskExecutor;
    private final TaskDBService taskDBService;
    private final ClusterLockService clusterLockService;
    private static final String COMPLIANCE_TASK_CLUSTER_LOCK = "COMPLIANCE_TASK";
    private final Random random = new Random();
    private final TransactionTemplate transactionTemplate;

    @Inject
    public TaskExecutionService(TaskExecutor taskExecutor, TaskDBService taskDBService, ClusterLockService clusterLockService, TransactionTemplate transactionTemplate) {
        this.taskExecutor = taskExecutor;
        this.taskDBService = taskDBService;
        this.clusterLockService = clusterLockService;
        this.transactionTemplate = transactionTemplate;
    }

    public boolean isBusy() {
        return this.taskExecutor.getRunningTask() != null;
    }

    public void runTask(int taskId) throws TaskExecutionException, InterruptedException {
        TaskJson taskJson = (TaskJson)this.transactionTemplate.execute(() -> this.taskDBService.getTask(taskId));
        if (!this.isDelegated(taskJson)) {
            return;
        }
        if (!this.isExecutorReady()) {
            throw new TaskExecutionException("Executor thread failed to initialise");
        }
        boolean taskMarked = this.markTaskAsReady(taskJson.getId());
        if (!taskMarked) {
            throw new TaskExecutionException("Task could not be marked as ready to execute");
        }
        if (taskJson.isExclusiveExecution()) {
            this.handleExclusiveTask(taskJson);
        } else if (!this.isExclusiveTaskRunning()) {
            this.taskExecutor.submitTask(taskJson);
        }
    }

    public void cancelTask(int taskId) throws TaskCancellationException {
        this.taskExecutor.cancelTaskWithId(taskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExclusiveTask(TaskJson taskJson) throws TaskExecutionException, InterruptedException {
        ClusterLock lock = this.clusterLockService.getLockForName(COMPLIANCE_TASK_CLUSTER_LOCK);
        try {
            if (!lock.tryLock(30L, TimeUnit.MINUTES)) {
                throw new TaskExecutionException("Exclusive cluster lock found with no reported running tasks");
            }
            long randomOffset = (long)this.random.nextInt(40) + 10L;
            Thread.sleep(250L + randomOffset);
            if (!this.isOnlyOneTaskReadyToExecute()) {
                throw new TaskExecutionException(String.format("Other task awaiting start on cluster. cannot start on %s", taskJson.getElectedNode()));
            }
            this.taskExecutor.submitTask(taskJson);
        }
        finally {
            lock.unlock();
        }
    }

    private boolean isExecutorReady() throws InterruptedException {
        for (int waitTime = 20; waitTime <= 240; waitTime *= 2) {
            if (this.taskExecutor.isReady()) {
                return true;
            }
            Thread.sleep(waitTime);
        }
        return false;
    }

    private boolean markTaskAsReady(int taskId) {
        return (Boolean)this.transactionTemplate.execute(() -> {
            try {
                TaskDBServiceUtils.updateTaskStatus(this.taskDBService, taskId, TaskStatusEnum.READY_TO_EXECUTE);
                return true;
            }
            catch (NoSuchTaskException e) {
                return false;
            }
        });
    }

    private boolean isExclusiveTaskRunning() {
        return (Boolean)this.transactionTemplate.execute(() -> this.taskDBService.getAllTasksByStatuses(TaskStatusEnum.IN_PROGRESS).stream().anyMatch(TaskJson::isExclusiveExecution));
    }

    private boolean isDelegated(TaskJson task) {
        return task.getStatus().equals((Object)TaskStatusEnum.DELEGATED);
    }

    private boolean isOnlyOneTaskReadyToExecute() {
        return (Boolean)this.transactionTemplate.execute(() -> {
            int numTasksReadyToExecute = this.taskDBService.getAllTasksByStatuses(TaskStatusEnum.READY_TO_EXECUTE).size();
            return numTasksReadyToExecute <= 1;
        });
    }
}

