/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service.task;

import co.uk.automationconsultants.compliance.exception.task.TaskCancellationException;
import co.uk.automationconsultants.compliance.json.task.TaskJson;
import co.uk.automationconsultants.compliance.json.task.TaskStatusEnum;
import co.uk.automationconsultants.compliance.service.task.TaskDBService;
import co.uk.automationconsultants.compliance.service.task.TaskExecutionService;
import co.uk.automationconsultants.compliance.task.event.SingleNodeTaskCancellationEvent;
import co.uk.automationconsultants.compliance.utils.TaskClusterUtils;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import jakarta.inject.Inject;
import jakarta.inject.Named;

@Named(value="taskCancellationService")
public class TaskCancellationService {
    @ComponentImport
    private final ClusterManager clusterManager;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    private final TaskDBService taskDBService;
    private final TaskExecutionService taskExecutionService;
    @ComponentImport
    private final EventPublisher eventPublisher;

    @Inject
    public TaskCancellationService(ClusterManager clusterManager, TransactionTemplate transactionTemplate, TaskDBService taskDBService, TaskExecutionService taskExecutionService, EventPublisher eventPublisher) {
        this.clusterManager = clusterManager;
        this.transactionTemplate = transactionTemplate;
        this.taskDBService = taskDBService;
        this.taskExecutionService = taskExecutionService;
        this.eventPublisher = eventPublisher;
    }

    public void cancelTask(int id) throws TaskCancellationException {
        TaskJson taskJson = (TaskJson)this.transactionTemplate.execute(() -> this.taskDBService.getTask(id));
        if (TaskStatusEnum.isFinishedStatus(taskJson.getStatus())) {
            throw new TaskCancellationException();
        }
        if (taskJson.isRunning()) {
            this.cancelRunningTask(taskJson);
        } else {
            this.cancelNonRunningTask(id);
        }
    }

    private void cancelNonRunningTask(int id) {
        this.transactionTemplate.execute(() -> {
            this.taskDBService.cancelTask(id);
            return null;
        });
    }

    private void cancelRunningTask(TaskJson taskJson) throws TaskCancellationException {
        boolean taskBelongsToCurrNode = TaskClusterUtils.belongsToCurrNode(taskJson, this.clusterManager.getThisNodeInformation());
        if (taskBelongsToCurrNode) {
            this.taskExecutionService.cancelTask(taskJson.getId());
        } else {
            this.eventPublisher.publish((Object)new SingleNodeTaskCancellationEvent(taskJson.getElectedNode(), taskJson.getId()));
        }
    }
}

