/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service.maintenance;

import co.uk.automationconsultants.compliance.entity.analysis.ExtractionResult;
import co.uk.automationconsultants.compliance.entity.automation.ActionInstance;
import co.uk.automationconsultants.compliance.json.capture.ExtractionResultJson;
import co.uk.automationconsultants.compliance.service.AnalysisService;
import co.uk.automationconsultants.compliance.service.maintenance.ExtractionResultCursor;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.pages.Page;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.inject.Named;
import java.util.HashSet;
import java.util.List;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="extractionResultMaintenanceService")
public class ExtractionResultMaintenanceService {
    private static final int REQUEST_LIMIT = 50;
    private static final String MAINTENANCE_LOCK_NAME = AnalysisService.class.getName() + ".maintenanceTask";
    private static final Logger log = LoggerFactory.getLogger(ExtractionResultMaintenanceService.class);
    @ComponentImport
    private final ContentService contentService;
    @ComponentImport
    private final SpaceService spaceService;
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final ClusterLockService clusterLockService;

    public ExtractionResultMaintenanceService(ContentService contentService, SpaceService spaceService, ActiveObjects activeObjects, ClusterLockService clusterLockService) {
        this.contentService = contentService;
        this.spaceService = spaceService;
        this.activeObjects = activeObjects;
        this.clusterLockService = clusterLockService;
    }

    public int performMaintenance() {
        return this.handleMaintenance(false);
    }

    public void updateExtractionResultSpaceId(Page page, Long newSpaceId) {
        ExtractionResult[] extractionResults = (ExtractionResult[])this.activeObjects.find(ExtractionResult.class, Query.select().where("PAGE_ID = ?", new Object[]{page.getId()}));
        for (ExtractionResult extractionResult : extractionResults) {
            extractionResult.setSpaceId(newSpaceId);
            extractionResult.save();
        }
        for (Page child : page.getChildren()) {
            this.updateExtractionResultSpaceId(child, newSpaceId);
        }
    }

    public int getInvalidEntriesSize() {
        return this.handleMaintenance(true);
    }

    private int handleMaintenance(boolean readOnly) {
        return this.removeInvalidEntries(readOnly) + this.validateSpaceIds(readOnly);
    }

    public int validateSpaceIds(boolean readOnly) {
        ExtractionResult[] extractionResults;
        int invalid = 0;
        ExtractionResultCursor extractionResultCursor = new ExtractionResultCursor();
        boolean isMore = true;
        while (isMore && (extractionResults = (ExtractionResult[])this.activeObjects.find(ExtractionResult.class, this.generateCursorQuery(extractionResultCursor))).length != 0) {
            extractionResultCursor.setCursorValues(extractionResults[extractionResults.length - 1]);
            for (ExtractionResult extractionResult : extractionResults) {
                Content content = (Content)this.contentService.find(new Expansion[]{new Expansion("space")}).withId(ContentId.of((long)extractionResult.getPageId())).fetchOrNull();
                if (content == null) continue;
                Space space = content.getSpace();
                if (extractionResult.getSpaceId().longValue() == space.getId()) continue;
                ++invalid;
                if (readOnly) continue;
                extractionResult.setSpaceId(space.getId());
                extractionResult.save();
            }
            isMore = extractionResults.length == 50;
        }
        return invalid;
    }

    private int removeInvalidEntries(boolean readOnly) {
        ClusterLock lock = this.clusterLockService.getLockForName(MAINTENANCE_LOCK_NAME);
        if (lock.tryLock()) {
            int invalidEntries = 0;
            invalidEntries += this.removeDuplicateEntries(readOnly);
            lock.unlock();
            return invalidEntries += this.removeDeletedPageEntries(readOnly);
        }
        log.debug("Extraction Result Maintenance task has already started");
        return 0;
    }

    private int removeDuplicateEntries(boolean readOnly) {
        int duplicateEntries = 0;
        int start = 0;
        boolean isMore = true;
        while (isMore) {
            PageResponse pageResponse = this.spaceService.find(new Expansion[0]).fetchMany((PageRequest)new SimplePageRequest(start, 50));
            List spaces = pageResponse.getResults();
            for (Space space : spaces) {
                duplicateEntries += this.removeDuplicatesInSpace(space, readOnly);
            }
            start += 50;
            isMore = pageResponse.hasMore();
        }
        return duplicateEntries;
    }

    private int removeDuplicatesInSpace(Space space, boolean readOnly) {
        int duplicateEntries = 0;
        try {
            int start = 0;
            boolean isMore = true;
            while (isMore) {
                PageResponse pageResponse = this.contentService.find(new Expansion[]{new Expansion("version")}).withSpace(new Space[]{space}).fetchMany(ContentType.PAGE, (PageRequest)new SimplePageRequest(start, 50));
                List results = pageResponse.getResults();
                for (Content content : results) {
                    duplicateEntries += this.removeDuplicatesOnPage(content, readOnly);
                }
                start += 50;
                isMore = pageResponse.hasMore();
            }
        }
        catch (Exception e) {
            log.error("Error in Space Maintenance: {}", (Object)e.getMessage());
        }
        return duplicateEntries;
    }

    private int removeDuplicatesOnPage(Content content, boolean readOnly) {
        int duplicateEntries = 0;
        try {
            ExtractionResult[] extractionResults = (ExtractionResult[])this.activeObjects.find(ExtractionResult.class, Query.select().where("PAGE_ID = ?", new Object[]{content.getId().asLong()}));
            HashSet<ExtractionResultJson> resultSet = new HashSet<ExtractionResultJson>();
            for (ExtractionResult extractionResult : extractionResults) {
                ExtractionResultJson extractionResultJson;
                if (extractionResult.isActive() && content.getVersion().getNumber() > extractionResult.getPageVersion()) {
                    extractionResult.setActive(false);
                    extractionResult.save();
                }
                if (resultSet.contains(extractionResultJson = new ExtractionResultJson(extractionResult.getExtractionEntity().getID(), extractionResult.getPageId(), extractionResult.getPageVersion(), extractionResult.getCapturedText())) && this.deleteExtractionResult(extractionResult, readOnly)) {
                    ++duplicateEntries;
                }
                resultSet.add(extractionResultJson);
            }
        }
        catch (Exception e) {
            log.error("Error in Page Maintenance: {}", (Object)e.getMessage());
        }
        return duplicateEntries;
    }

    private Query generateCursorQuery(ExtractionResultCursor extractionResultCursor) {
        String fields = "ID, PAGE_ID, ACTIVE, PAGE_VERSION, CAPTURED_TEXT, EXTRACTION_ENTITY_ID";
        if (extractionResultCursor.getExtractionId() <= 0 && extractionResultCursor.getPageId() == null) {
            return Query.select((String)fields).order("PAGE_ID ASC, ID ASC").limit(50);
        }
        return Query.select((String)fields).where("ID > ? AND PAGE_ID >= ?", new Object[]{extractionResultCursor.getExtractionId(), extractionResultCursor.getPageId()}).order("PAGE_ID ASC, ID ASC").limit(50);
    }

    private int removeDeletedPageEntries(boolean readOnly) {
        ExtractionResult[] extractionResults;
        ExtractionResultCursor extractionResultCursor = new ExtractionResultCursor();
        boolean isMore = true;
        int invalidEntries = 0;
        while (isMore && (extractionResults = (ExtractionResult[])this.activeObjects.find(ExtractionResult.class, this.generateCursorQuery(extractionResultCursor))).length != 0) {
            extractionResultCursor.setCursorValues(extractionResults[extractionResults.length - 1]);
            for (ExtractionResult extractionResult : extractionResults) {
                Content content = (Content)this.contentService.find(new Expansion[]{new Expansion("version")}).withId(ContentId.of((long)extractionResult.getPageId())).fetchOrNull();
                if (content != null || !this.deleteExtractionResult(extractionResult, readOnly)) continue;
                ++invalidEntries;
            }
            isMore = extractionResults.length == 50;
        }
        return invalidEntries;
    }

    private boolean deleteExtractionResult(ExtractionResult extractionResult, boolean readOnly) {
        if (this.activeObjects.count(ActionInstance.class, Query.select().where("EXTRACTION_RESULT_ID = ?", new Object[]{extractionResult.getID()})) == 0) {
            if (!readOnly) {
                this.activeObjects.delete(new RawEntity[]{extractionResult});
            }
            return true;
        }
        return false;
    }
}

