/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service.maintenance;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.pages.Page;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="contentPropertyMaintenanceService")
public class ContentPropertyMaintenanceService {
    @ComponentImport
    private final ContentPropertyService contentPropertyService;
    @ComponentImport
    private final ContentService contentService;
    private static final Logger log = LoggerFactory.getLogger(ContentPropertyMaintenanceService.class);

    @Inject
    public ContentPropertyMaintenanceService(ContentPropertyService contentPropertyService, ContentService contentService) {
        this.contentPropertyService = contentPropertyService;
        this.contentService = contentService;
    }

    public void reAddContentProperty(String propertyKey, Page page) {
        try {
            JsonContentProperty jsonContentProperty = this.getContentProperty(propertyKey, page);
            if (jsonContentProperty == null) {
                log.warn("No existing content property found for key {} on page {}", (Object)propertyKey, (Object)page.getTitle());
                return;
            }
            JsonString jsonString = jsonContentProperty.getValue();
            this.deleteContentProperty(propertyKey, page);
            log.debug("ReAddContentProperty: Deleted content property {} for page {} with Id {}", new Object[]{jsonContentProperty, page.getTitle(), page.getId()});
            this.createContentProperty(propertyKey, page, jsonString);
            log.debug("ReAddContentProperty: Created new content property {} for page {} with Id {}", new Object[]{propertyKey, page.getTitle(), page.getId()});
        }
        catch (Exception e) {
            log.error("Error re-adding content property {} for page {}: {}", new Object[]{propertyKey, page.getTitle(), e.getMessage()});
        }
    }

    public void createContentProperty(String propertyKey, Page page, JsonString jsonString) {
        try {
            Content content = (Content)this.contentService.find(new Expansion[0]).withId(page.getContentId()).fetchOrNull();
            if (content == null) {
                log.error("Content not found for page {} when re-adding content property {}", (Object)page.getId(), (Object)propertyKey);
            }
            JsonContentProperty newContentProperty = JsonContentProperty.builder().content(content).key(propertyKey).value(jsonString).build();
            ValidationResult validationCreate = this.contentPropertyService.validator().validateCreate(newContentProperty);
            if (validationCreate.isSuccessful()) {
                this.contentPropertyService.create(newContentProperty);
            } else {
                log.error("Failed to validate creation for old content property {} for page {} with Id {}: {}", new Object[]{propertyKey, page.getTitle(), page.getId(), validationCreate.getErrors()});
            }
        }
        catch (Exception e) {
            log.error("Error creating content property {} for page {} with Id {}: {}", new Object[]{propertyKey, page.getTitle(), page.getId(), e.getMessage()});
        }
    }

    public JsonContentProperty getContentProperty(String propertyKey, Page page) {
        return (JsonContentProperty)this.contentPropertyService.find(new Expansion[0]).withContentId(page.getContentId()).withPropertyKey(propertyKey).fetchOrNull();
    }

    public void deleteContentProperty(String propertyKey, Page page) {
        try {
            JsonContentProperty jsonContentProperty = this.getContentProperty(propertyKey, page);
            if (jsonContentProperty != null) {
                ValidationResult validationResult = this.contentPropertyService.validator().validateDelete(jsonContentProperty);
                if (validationResult.isSuccessful()) {
                    this.contentPropertyService.delete(jsonContentProperty);
                } else {
                    log.error("Failed to validate deletion for old content property {} for page {} with Id {}: {}", new Object[]{propertyKey, page.getTitle(), page.getId(), validationResult.getErrors()});
                }
            }
        }
        catch (Exception e) {
            log.error("Error deleting content property {} for page {} with Id {}: {}", new Object[]{propertyKey, page.getTitle(), page.getId(), e.getMessage()});
        }
    }

    public void reAddComplianceContentProperties(Page page) {
        List children = page.getChildren();
        if (children != null && !children.isEmpty()) {
            for (Page child : children) {
                try {
                    this.reAddComplianceContentProperties(child);
                    log.debug("ReAddComplianceContentProperties: Child page {} with Id {} re-added compliance content property", (Object)child.getTitle(), (Object)child.getId());
                }
                catch (Exception e) {
                    log.error("Error re-adding content property on child page {}: {}", (Object)child.getTitle(), (Object)e.getMessage());
                }
            }
        }
        for (String propertyKey : Arrays.asList("classificationhistory", "classification", "classificationanalysis")) {
            try {
                this.reAddContentProperty(propertyKey, page);
                log.debug("ReAddComplianceContentProperties: Page {} with Id {} re-added content property {}", new Object[]{page.getTitle(), page.getId(), propertyKey});
            }
            catch (Exception e) {
                log.error("Error re-adding compliance content property {} for page {}: {}", new Object[]{propertyKey, page.getTitle(), e.getMessage()});
            }
        }
    }
}

