/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.service;

import co.uk.automationconsultants.compliance.entity.scope.ScopeEntity;
import co.uk.automationconsultants.compliance.entity.scope.ScopeSpaceEntity;
import co.uk.automationconsultants.compliance.json.scope.ScopeBaseJson;
import co.uk.automationconsultants.compliance.json.scope.ScopeEnum;
import co.uk.automationconsultants.compliance.json.settings.StatusJson;
import co.uk.automationconsultants.compliance.json.task.TaskJson;
import co.uk.automationconsultants.compliance.json.task.TaskStatusEnum;
import co.uk.automationconsultants.compliance.json.task.TaskTypeEnum;
import co.uk.automationconsultants.compliance.service.task.TaskDBService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.annotation.Nonnull;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.java.ao.Query;
import org.apache.commons.lang3.EnumUtils;

@Named(value="scopeService")
public class ScopeService {
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final CQLSearchService cqlSearchService;
    private final TaskDBService taskDBService;

    public ScopeService(ActiveObjects activeObjects, SpaceManager spaceManager, CQLSearchService cqlSearchService, TaskDBService taskDBService) {
        this.activeObjects = activeObjects;
        this.spaceManager = spaceManager;
        this.cqlSearchService = cqlSearchService;
        this.taskDBService = taskDBService;
    }

    public ScopeBaseJson getScope() {
        ScopeEntity[] scope = (ScopeEntity[])this.activeObjects.find(ScopeEntity.class, Query.select().order("ID DESC").limit(1));
        if (scope.length == 0) {
            return new ScopeBaseJson(ScopeEnum.DISABLED);
        }
        switch (scope[0].getScope()) {
            case "enabled": {
                return new ScopeBaseJson(ScopeEnum.ENABLED);
            }
            case "spaces": {
                ArrayList<String> spaces = new ArrayList<String>();
                this.activeObjects.stream(ScopeSpaceEntity.class, s -> spaces.add(s.getSpaceKey()));
                spaces.removeIf(sk -> this.spaceManager.getSpace(sk) == null);
                return new ScopeBaseJson(ScopeEnum.SPACES, spaces);
            }
        }
        return new ScopeBaseJson(ScopeEnum.DISABLED);
    }

    public ScopeEnum getScopeState() {
        ScopeEntity[] scope = (ScopeEntity[])this.activeObjects.find(ScopeEntity.class, Query.select().order("ID DESC").limit(1));
        if (scope.length == 0) {
            return ScopeEnum.DISABLED;
        }
        return (ScopeEnum)EnumUtils.getEnumIgnoreCase(ScopeEnum.class, (String)scope[0].getScope());
    }

    public StatusJson getStatus() {
        return this.getStatusInternal(null);
    }

    public StatusJson getStatus(ScopeBaseJson scope) {
        return this.getStatusInternal(scope);
    }

    public boolean inScope(Space space, @Nonnull ScopeBaseJson scope) {
        if (scope.getState().equals((Object)ScopeEnum.DISABLED)) {
            return false;
        }
        if (scope.getState().equals((Object)ScopeEnum.SPACES)) {
            return scope.getSpaces().stream().anyMatch(s -> s.equalsIgnoreCase(space.getKey()));
        }
        return true;
    }

    private StatusJson getStatusInternal(ScopeBaseJson scope) {
        if (this.getScopeState() == ScopeEnum.SPACES && this.activeObjects.count(ScopeSpaceEntity.class) > 250) {
            return new StatusJson(true);
        }
        if (scope == null) {
            scope = this.getScope();
        }
        if (scope.getState() == ScopeEnum.DISABLED || scope.getState() == ScopeEnum.SPACES && scope.getSpaces().isEmpty()) {
            return new StatusJson(0, 0, 0, false, null);
        }
        String query = "type = page";
        if (scope.getState() == ScopeEnum.SPACES) {
            query = query.concat(String.format(" AND space IN ( %s)", scope.getSpaces().stream().map(space -> "\"" + space + "\"").collect(Collectors.joining(","))));
        }
        int scanned = this.cqlSearchService.countContent(query.concat(" AND content.property[classificationanalysis].constant = 1"), SearchContext.builder().build());
        int editedSinceScan = this.cqlSearchService.countContent(query.concat(" AND content.property[classificationanalysis].constant = 0"), SearchContext.builder().build());
        int unscanned = this.cqlSearchService.countContent(query.concat(" AND (content.property[classificationanalysis].constant != 1 AND content.property[classificationanalysis].constant != 0)"), SearchContext.builder().build());
        boolean isScanRunning = this.taskDBService.getAllTasksByStatuses(TaskStatusEnum.IN_PROGRESS).stream().anyMatch(t -> t.getTaskType() == TaskTypeEnum.SENSITIVE_DATA_SCAN);
        TaskJson lastScan = this.taskDBService.getLastTaskByTypeAndStatus(TaskTypeEnum.SENSITIVE_DATA_SCAN, TaskStatusEnum.SUCCESS, TaskStatusEnum.SUCCESS_WITH_ERRORS, TaskStatusEnum.FAILED, TaskStatusEnum.TERMINATED);
        TaskStatusEnum lastScanStatus = lastScan != null ? lastScan.getStatus() : null;
        return new StatusJson(scanned, editedSinceScan, unscanned, isScanRunning, lastScanStatus);
    }
}

