/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.json.capture.WhitelistFullJson;
import co.uk.automationconsultants.compliance.json.capture.WhitelistJson;
import co.uk.automationconsultants.compliance.service.WhitelistService;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@Path(value="/whitelist")
public class WhitelistRest {
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final PageManager pageManager;
    private final WhitelistService whitelistService;

    @Inject
    public WhitelistRest(WhitelistService whitelistService, PermissionManager permissionManager, UserManager userManager, UserAccessor userAccessor, SpaceManager spaceManager, PageManager pageManager) {
        this.whitelistService = whitelistService;
        this.permissionManager = permissionManager;
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getWhitelist(@Context HttpServletRequest request) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.ok(this.whitelistService.getWhitelist()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createWhitelist(@Context HttpServletRequest request, WhitelistJson whitelistJson) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.ok((Object)WhitelistFullJson.map(this.whitelistService.createWhitelistItem(whitelistJson.getSpace(), whitelistJson.getPage(), whitelistJson.getText()), this.spaceManager, this.pageManager)).build();
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteWhitelist(@Context HttpServletRequest request, @QueryParam(value="id") Integer id) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.whitelistService.deleteWhitelistItem(id);
        return Response.ok((Object)id).build();
    }
}

