/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.service.StatisticsService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.Objects;

@Path(value="/statistics")
public class StatisticsRest {
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    private final StatisticsService statisticsService;

    @Inject
    public StatisticsRest(SpaceManager spaceManager, UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager, StatisticsService statisticsService) {
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.statisticsService = statisticsService;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getStatistics(@Context HttpServletRequest request, @QueryParam(value="spaceKey") String spaceKey) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (spaceKey == null) {
            if (this.permissionManager.isConfluenceAdministrator(user)) {
                return Response.ok(this.statisticsService.getAllStatistics()).build();
            }
        } else {
            if (this.permissionManager.hasPermission(user, Permission.ADMINISTER, (Object)this.spaceManager.getSpace(spaceKey))) {
                return Response.ok(Collections.singletonList(this.statisticsService.getStatistics(spaceKey))).build();
            }
            return Response.status((int)403).build();
        }
        Response.status((int)403).build();
        return Response.status((int)401).build();
    }
}

