/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@Path(value="/spaceAdmin")
public class SpaceAdminRest {
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final SpaceManager spaceManager;

    @Inject
    public SpaceAdminRest(UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager, SpaceManager spaceManager) {
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
    }

    @GET
    @Produces(value={"application/json"})
    public Response checkIfSpaceAdmin(@Context HttpServletRequest request, @QueryParam(value="spaceKey") String spaceKey) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        boolean isSpaceAdmin = this.permissionManager.hasPermission(user, Permission.ADMINISTER, (Object)this.spaceManager.getSpace(spaceKey));
        String json = "{\"isSpaceAdmin\": " + isSpaceAdmin + "}";
        return Response.ok((Object)json, (String)"application/json").build();
    }
}

