/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.entity.SettingEntity;
import co.uk.automationconsultants.compliance.json.settings.ScanSettings;
import co.uk.automationconsultants.compliance.service.AnalysisService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import net.java.ao.Query;

@Path(value="/settings")
public class SettingsRest {
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    private final AnalysisService analysisService;

    @Inject
    public SettingsRest(ActiveObjects activeObjects, UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager, AnalysisService analysisService) {
        this.activeObjects = activeObjects;
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.analysisService = analysisService;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getSettings(@Context HttpServletRequest request) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SettingEntity[] settings = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().order("ID DESC").limit(1));
        if (settings.length == 0) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok((Object)new ScanSettings(settings[0].getRealTimeScan(), settings[0].getRealTimeScanPrevVersions(), settings[0].getScheduledScan(), settings[0].getActingUser(), settings[0].getOnlyScanNewOrEdited(), settings[0].getOnlyScanUnscanned())).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response setSettings(@Context HttpServletRequest request, ScanSettings newSettings) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (!this.permissionManager.isConfluenceAdministrator(this.userAccessor.getUserByName(newSettings.getActingUser()))) {
            return Response.status((int)400).build();
        }
        SettingEntity[] settings = (SettingEntity[])this.activeObjects.find(SettingEntity.class, Query.select().order("ID DESC").limit(1));
        if (settings.length == 0) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        SettingEntity settingEntity = (SettingEntity)this.activeObjects.executeInTransaction(() -> {
            settings[0].setRealTimeScan(newSettings.getRealTime());
            settings[0].setScheduledScan(newSettings.getScheduled());
            settings[0].setActingUser(newSettings.getActingUser());
            settings[0].setRealTimeScanPrevVersions(newSettings.getRealTimeScanPrevVersions());
            settings[0].setOnlyScanNewOrEdited(newSettings.getOnlyScanNewOrEdited());
            settings[0].setOnlyScanUnscanned(newSettings.getOnlyScanUnscanned());
            settings[0].save();
            return settings[0];
        });
        return Response.ok((Object)new ScanSettings(settingEntity.getRealTimeScan(), settingEntity.getRealTimeScanPrevVersions(), settingEntity.getScheduledScan(), settingEntity.getActingUser(), settingEntity.getOnlyScanNewOrEdited(), settingEntity.getOnlyScanUnscanned())).build();
    }

    @GET
    @Path(value="/status")
    @Produces(value={"application/json"})
    public Response getStatus(@Context HttpServletRequest request) {
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(Objects.requireNonNull(this.userManager.getRemoteUser(request)).getUserKey());
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.ok((Object)this.analysisService.getStatus()).build();
    }
}

